/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.services.job;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import javax.xml.namespace.QName;
import org.ow2.orchestra.env.Environment;
import org.ow2.orchestra.exception.FaultWithMessageVariable;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.runtime.BpelExecution;
import org.ow2.orchestra.services.job.MessageImpl;
import org.ow2.orchestra.services.jobexecutor.JobDbSession;
import org.ow2.orchestra.var.MessageVariable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SignalInvokeJob
extends MessageImpl<Void> {
    private static final long serialVersionUID = 1796627705334254482L;
    protected SignalInvokeJobData data = new SignalInvokeJobData();

    protected SignalInvokeJob() {
    }

    public SignalInvokeJob(MessageVariable responseMessage, Exception exception) {
        this.data.setResponseMessage(responseMessage != null ? responseMessage.duplicate() : null);
        this.data.setExceptionMessage(null);
        if (exception != null) {
            if (exception instanceof FaultWithMessageVariable) {
                FaultWithMessageVariable fault = (FaultWithMessageVariable)exception;
                this.data.setFaultName(fault.getFaultName());
                this.data.setResponseMessage(fault.getFaultMessage());
            } else {
                StringWriter sw = new StringWriter();
                exception.printStackTrace(new PrintWriter(sw));
                this.data.setExceptionMessage(sw.toString());
            }
        }
    }

    @Override
    public Void execute(Environment environment) {
        BpelExecution execution = this.getExecution();
        HashMap<String, Object> signalParams = new HashMap<String, Object>();
        if (this.data.getFaultName() != null) {
            signalParams.put("SIGNAL_PARAMETER_RECEIVED_EXCEPTION", new FaultWithMessageVariable(this.data.getFaultName(), this.data.getResponseMessage()));
        } else if (this.data.getExceptionMessage() != null && !this.data.getExceptionMessage().equals("")) {
            signalParams.put("SIGNAL_PARAMETER_RECEIVED_EXCEPTION", new OrchestraRuntimeException(this.data.getExceptionMessage()));
        } else {
            signalParams.put("SIGNAL_PARAMETER_RECEIVED_MSG", this.data.getResponseMessage());
        }
        execution.signal(signalParams);
        JobDbSession jobDbSession = environment.get(JobDbSession.class);
        jobDbSession.delete(this);
        return null;
    }

    public static class SignalInvokeJobData {
        private MessageVariable responseMessage;
        private String exceptionMessage;
        private QName faultName;

        public MessageVariable getResponseMessage() {
            return this.responseMessage;
        }

        public void setResponseMessage(MessageVariable responseMessage) {
            this.responseMessage = responseMessage;
        }

        public String getExceptionMessage() {
            return this.exceptionMessage;
        }

        public void setExceptionMessage(String exceptionMessage) {
            this.exceptionMessage = exceptionMessage;
        }

        public QName getFaultName() {
            return this.faultName;
        }

        public void setFaultName(QName faultName) {
            this.faultName = faultName;
        }
    }
}

