/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.services.job;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.orchestra.env.Environment;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.persistence.Transaction;
import org.ow2.orchestra.services.job.JobImpl;
import org.ow2.orchestra.services.job.Timer;
import org.ow2.orchestra.services.jobexecutor.JobAddedNotification;
import org.ow2.orchestra.services.jobexecutor.JobDbSession;
import org.ow2.orchestra.services.jobexecutor.JobExecutor;
import org.ow2.orchestra.util.Clock;
import org.ow2.orchestra.util.Misc;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimerImpl
extends JobImpl<Boolean>
implements Timer {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = Logger.getLogger(TimerImpl.class.getName());
    private static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss,SSS";
    protected String signalName;
    protected Long repeat;
    public static final String EVENT_TIMER = "timer";

    @Override
    public Boolean execute(Environment environment) {
        Misc.fastDynamicLog(LOG, Level.FINE, "executing %s", this);
        if (environment == null) {
            throw new OrchestraRuntimeException("environment is null");
        }
        if (this.signalName != null) {
            Misc.fastDynamicLog(LOG, Level.FINE, "feeding timer signal %s into %s", this.signalName, this.execution);
            this.execution.signal(this.signalName);
        }
        boolean deleteThisJob = true;
        if (this.repeat == null) {
            Misc.fastDynamicLog(LOG, Level.FINE, "deleting %s", this);
            JobDbSession dbSession = environment.get(JobDbSession.class);
            if (dbSession == null) {
                throw new OrchestraRuntimeException("no " + JobDbSession.class.getName() + " in environment");
            }
            dbSession.delete(this);
        } else {
            deleteThisJob = false;
            do {
                this.dueDate = new Date(System.currentTimeMillis() + this.repeat);
            } while (this.dueDate.getTime() <= Clock.getCurrentTime().getTime());
            Misc.fastDynamicLog(LOG, Level.FINE, "rescheduled %s for %s", this, TimerImpl.formatDueDate(this.dueDate));
            this.setLockOwner(null);
            this.setLockExpirationTime(null);
            JobExecutor jobExecutor = environment.get(JobExecutor.class);
            if (jobExecutor != null) {
                Transaction transaction = environment.get(Transaction.class);
                if (transaction == null) {
                    throw new OrchestraRuntimeException("no transaction in environment");
                }
                JobAddedNotification jobNotificator = new JobAddedNotification(jobExecutor, this);
                transaction.registerSynchronization(jobNotificator);
            }
        }
        return deleteThisJob;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("timer[");
        buffer.append(this.dbid);
        if (this.dueDate != null) {
            buffer.append("|");
            buffer.append(TimerImpl.formatDueDate(this.dueDate));
        }
        if (this.signalName != null) {
            buffer.append("|");
            buffer.append(this.signalName);
        }
        buffer.append("]");
        return buffer.toString();
    }

    public static String formatDueDate(Date date) {
        return new SimpleDateFormat(DATE_FORMAT).format(date);
    }

    @Override
    public String getSignalName() {
        return this.signalName;
    }

    public void setSignalName(String signalName) {
        this.signalName = signalName;
    }

    @Override
    public Long getRepeat() {
        return this.repeat;
    }

    public void setRepeat(Long repeat) {
        this.repeat = repeat;
    }
}

