/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.services.jobexecutor;

import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.hibernate.StaleStateException;
import org.hibernate.exception.GenericJDBCException;
import org.hibernate.exception.LockAcquisitionException;
import org.ow2.orchestra.services.commands.Command;
import org.ow2.orchestra.services.commands.CommandService;
import org.ow2.orchestra.services.commands.RetryInterceptor;
import org.ow2.orchestra.services.job.JobImpl;
import org.ow2.orchestra.services.jobexecutor.AbstractJobExecutor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDispatcherThread
extends Thread {
    private static final Logger LOG = Logger.getLogger(AbstractDispatcherThread.class.getName());
    private final ExecutorService addWaitingJobExecutor = Executors.newSingleThreadExecutor();
    private boolean isActive = true;
    private boolean checkForNewJobs;
    private final Object semaphore = new Object();

    public AbstractDispatcherThread() {
    }

    public AbstractDispatcherThread(Runnable target) {
        super(target);
    }

    public AbstractDispatcherThread(String name) {
        super(name);
    }

    public AbstractDispatcherThread(ThreadGroup group, Runnable target) {
        super(group, target);
    }

    protected abstract void putAcquiredJobOnQueue(JobImpl<?> var1);

    public AbstractDispatcherThread(ThreadGroup group, String name) {
        super(group, name);
    }

    public AbstractDispatcherThread(Runnable target, String name) {
        super(target, name);
    }

    public AbstractDispatcherThread(ThreadGroup group, Runnable target, String name) {
        super(group, target, name);
    }

    public AbstractDispatcherThread(ThreadGroup group, Runnable target, String name, long stackSize) {
        super(group, target, name, stackSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block26: {
            LOG.log(Level.INFO, "starting...");
            long delay = 50L;
            int delayFactor = 2;
            CommandService commandService = this.getJobExecutor().getCommandExecutor();
            if (commandService instanceof RetryInterceptor) {
                delay = ((RetryInterceptor)commandService).getDelay();
                delayFactor = ((RetryInterceptor)commandService).getDelayFactor();
            }
            long currentDelay = delay;
            block14: while (true) {
                while (this.isActive) {
                    JobImpl<?> job;
                    try {
                        long waitPeriod;
                        this.checkForNewJobs = false;
                        Collection<JobImpl<?>> acquiredJobs = this.acquireJobs();
                        currentDelay = delay;
                        if (acquiredJobs != null && !acquiredJobs.isEmpty()) {
                            Iterator<JobImpl<?>> i$ = acquiredJobs.iterator();
                            while (true) {
                                if (!i$.hasNext()) continue block14;
                                job = i$.next();
                                this.putAcquiredJobOnQueue(job);
                                if (!LOG.isLoggable(Level.FINEST)) continue;
                                LOG.log(Level.FINEST, "added job " + job + " to the queue");
                            }
                        }
                        if (!this.isActive || (waitPeriod = this.getWaitPeriod()) <= 0L) continue block14;
                        Object object = this.semaphore;
                        synchronized (object) {
                            if (!this.checkForNewJobs) {
                                if (LOG.isLoggable(Level.FINEST)) {
                                    LOG.log(Level.FINEST, this.getName() + " will wait for max " + waitPeriod + " ms on " + this.getJobExecutor());
                                }
                                this.semaphore.wait(waitPeriod);
                                if (LOG.isLoggable(Level.FINEST)) {
                                    LOG.log(Level.FINEST, this.getName() + " woke up");
                                }
                            } else if (LOG.isLoggable(Level.FINEST)) {
                                LOG.log(Level.FINEST, "skipped wait because new message arrived");
                            }
                            continue block14;
                        }
                    }
                    catch (InterruptedException e) {
                        if (!LOG.isLoggable(Level.FINEST)) continue;
                        LOG.log(Level.FINEST, (this.isActive ? "active" : "inactivated") + " jobImpl dispatcher thread '" + this.getName() + "' got interrupted");
                    }
                    catch (Exception e) {
                        block25: {
                            Level level = e instanceof StaleStateException || e instanceof LockAcquisitionException || e instanceof GenericJDBCException ? Level.FINEST : Level.SEVERE;
                            if (LOG.isLoggable(level)) {
                                LOG.log(level, "exception in job executor dispatcher thread. Waiting " + currentDelay + " milliseconds", e);
                            }
                            try {
                                job = this.semaphore;
                                synchronized (job) {
                                    this.semaphore.wait(currentDelay);
                                }
                            }
                            catch (InterruptedException e2) {
                                if (!LOG.isLoggable(Level.FINEST)) break block25;
                                LOG.log(Level.FINEST, "delay after exception got interrupted", e2);
                            }
                        }
                        currentDelay *= (long)delayFactor;
                    }
                }
                break block26;
                {
                    continue block14;
                    break;
                }
                break;
            }
            finally {
                LOG.log(Level.INFO, this.getName() + " leaves cyberspace");
            }
        }
    }

    protected Collection<JobImpl<?>> acquireJobs() {
        CommandService commandService = this.getJobExecutor().getCommandExecutor();
        Command<Collection<JobImpl<?>>> acquireJobsCommand = this.getJobExecutor().getAcquireJobsCommand();
        return commandService.execute(acquireJobsCommand);
    }

    protected Date getNextDueDate() {
        CommandService commandService = this.getJobExecutor().getCommandExecutor();
        Command<Date> getNextDueDate = this.getJobExecutor().getNextDueDateCommand();
        return commandService.execute(getNextDueDate);
    }

    protected long getWaitPeriod() {
        long interval = this.getJobExecutor().getIdleMillis();
        Date nextDueDate = this.getNextDueDate();
        if (nextDueDate != null) {
            long currentTimeMillis = System.currentTimeMillis();
            long nextDueDateTime = nextDueDate.getTime();
            if (nextDueDateTime < currentTimeMillis + interval) {
                interval = nextDueDateTime - currentTimeMillis;
            }
        }
        if (interval < 0L) {
            interval = 0L;
        }
        return interval;
    }

    public void deactivate() {
        this.deactivate(false);
    }

    public void deactivate(boolean join) {
        if (this.isActive) {
            LOG.log(Level.FINE, "deactivating " + this.getName());
            this.isActive = false;
            this.addWaitingJobExecutor.shutdown();
            this.interrupt();
            if (join) {
                while (this.isAlive()) {
                    try {
                        LOG.log(Level.FINEST, "joining " + this.getName());
                        this.join();
                        this.addWaitingJobExecutor.awaitTermination(180L, TimeUnit.SECONDS);
                    }
                    catch (InterruptedException e) {
                        LOG.log(Level.FINEST, "joining " + this.getName() + " got interrupted");
                    }
                }
            }
        } else {
            LOG.log(Level.FINEST, "ignoring deactivate: " + this.getName() + " is not active");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void jobWasAdded() {
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.log(Level.FINEST, "notifying jobImpl executor dispatcher thread of new jobImpl");
        }
        Object object = this.semaphore;
        synchronized (object) {
            this.checkForNewJobs = true;
            this.semaphore.notify();
        }
    }

    public void addWaitingJob(JobImpl<?> job) {
        this.addWaitingJobExecutor.execute(new AddJobTask(job));
    }

    public boolean isActive() {
        return this.isActive;
    }

    public abstract AbstractJobExecutor getJobExecutor();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class AddJobTask
    implements Runnable {
        private final JobImpl<?> job;

        private AddJobTask(JobImpl<?> job) {
            this.job = job;
        }

        @Override
        public void run() {
            AbstractDispatcherThread.this.getJobExecutor().getDispatcherThread().putAcquiredJobOnQueue(this.job);
        }
    }
}

