/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.services.jobexecutor;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.orchestra.env.Environment;
import org.ow2.orchestra.runtime.BpelInstance;
import org.ow2.orchestra.services.commands.Command;
import org.ow2.orchestra.services.job.JobImpl;
import org.ow2.orchestra.services.jobexecutor.AbstractJobExecutor;
import org.ow2.orchestra.services.jobexecutor.JobDbSession;
import org.ow2.orchestra.util.Misc;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AcquireJobsCmd
implements Command<Collection<JobImpl<?>>> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = Logger.getLogger(AcquireJobsCmd.class.getName());
    private final DateFormat timeFormat = new SimpleDateFormat("HH:mm:ss,SSS");
    private final String lockOwnerName;
    private final int lockMillis;
    private final AbstractJobExecutor jobExecutor;
    private final boolean limitSameInstanceJobs;

    public AcquireJobsCmd(AbstractJobExecutor jobExecutor, String lockOwnerName, int lockMillis, boolean limitSameInstanceJobs) {
        this.jobExecutor = jobExecutor;
        this.lockOwnerName = lockOwnerName;
        this.lockMillis = lockMillis;
        this.limitSameInstanceJobs = limitSameInstanceJobs;
    }

    @Override
    public Collection<JobImpl<?>> execute(Environment environment) {
        ArrayList result = new ArrayList();
        JobDbSession jobDbSession = environment.get(JobDbSession.class);
        Misc.fastDynamicLog(LOG, Level.FINE, "start querying first acquirable jobImpl...", new Object[0]);
        int limit = this.jobExecutor.getAcquireJobSize();
        Collection<JobImpl<?>> jobs = jobDbSession.findFirstAcquirableJob(limit, this.limitSameInstanceJobs);
        if (jobs != null && !jobs.isEmpty()) {
            HashSet<BpelInstance> instances = new HashSet<BpelInstance>();
            for (JobImpl<?> acquiredJob : jobs) {
                if (instances.contains(acquiredJob.getExecution().getProcessInstance())) continue;
                instances.add(acquiredJob.getExecution().getProcessInstance());
                long lockExpirationTime = System.currentTimeMillis() + (long)this.lockMillis;
                Misc.fastDynamicLog(LOG, Level.FINEST, "trying to obtain a lock for '%s' with exp %s", acquiredJob, this.timeFormat.format(new Date(lockExpirationTime)));
                acquiredJob.setLockExpirationTime(new Date(lockExpirationTime));
                acquiredJob.setLockOwner(this.lockOwnerName);
                result.add(acquiredJob);
            }
        } else {
            Misc.fastDynamicLog(LOG, Level.FINEST, "no acquirable jobs in jobImpl table", new Object[0]);
        }
        Misc.fastDynamicLog(LOG, Level.FINE, "locking jobs %s", result);
        return result;
    }
}

