/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.services.jobexecutor;

import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.orchestra.env.Environment;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.services.commands.Command;
import org.ow2.orchestra.services.job.Job;
import org.ow2.orchestra.services.job.JobImpl;
import org.ow2.orchestra.services.jobexecutor.JobDbSession;
import org.ow2.orchestra.util.Misc;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecuteJobCmd
implements Command<Job> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = Logger.getLogger(ExecuteJobCmd.class.getName());
    protected JobImpl<?> jobToExecute;

    public ExecuteJobCmd(JobImpl<?> job) {
        this.jobToExecute = job;
    }

    @Override
    public Job execute(Environment environment) {
        JobDbSession session = environment.get(JobDbSession.class);
        if (session == null) {
            throw new OrchestraRuntimeException("no job session configured to get job " + this.jobToExecute + " for execution");
        }
        int oldVersion = this.jobToExecute.getDbversion();
        JobImpl job = session.get(JobImpl.class, this.jobToExecute.getDbid());
        if (job == null) {
            Misc.fastDynamicLog(LOG, Level.FINE, "job %s no longer exists", this.jobToExecute);
            return null;
        }
        if (oldVersion != job.getDbversion()) {
            Misc.fastDynamicLog(LOG, Level.FINE, "job %s updated externally", this.jobToExecute);
            return job;
        }
        Misc.fastDynamicLog(LOG, Level.FINE, "executing job %s...", job);
        job.execute(environment);
        Misc.fastDynamicLog(LOG, Level.FINE, "executed job %s", job);
        Date lockExpirationDate = job.getLockExpirationTime();
        if (lockExpirationDate != null) {
            long lockExpiration = lockExpirationDate.getTime();
            long currentTime = System.currentTimeMillis();
            if (currentTime > lockExpiration) {
                throw new OrchestraRuntimeException("job took too long: lock expired " + (currentTime - lockExpiration) + "ms ago");
            }
        }
        return job;
    }
}

