/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.services.jobexecutor;

import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.orchestra.env.Environment;
import org.ow2.orchestra.services.commands.Command;
import org.ow2.orchestra.services.job.JobImpl;
import org.ow2.orchestra.services.jobexecutor.JobDbSession;
import org.ow2.orchestra.util.Misc;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetNextDueDateCmd
implements Command<Date> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = Logger.getLogger(GetNextDueDateCmd.class.getName());

    @Override
    public Date execute(Environment environment) {
        Date nextDueDate = null;
        Misc.fastDynamicLog(LOG, Level.FINE, "getting next due date...", new Object[0]);
        JobDbSession jobDbSession = environment.get(JobDbSession.class);
        JobImpl<?> job = jobDbSession.findFirstDueJob();
        if (job != null) {
            nextDueDate = job.getDueDate();
        }
        Misc.fastDynamicLog(LOG, Level.FINE, "next due date is %s", nextDueDate);
        return nextDueDate;
    }
}

