/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.services.jobexecutor;

import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.Synchronization;
import org.ow2.orchestra.services.job.JobImpl;
import org.ow2.orchestra.services.jobexecutor.AbstractJobExecutor;
import org.ow2.orchestra.services.jobexecutor.JobExecutor;
import org.ow2.orchestra.util.Misc;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobAddedNotification
implements Synchronization {
    private static final Logger LOG = Logger.getLogger(JobAddedNotification.class.getName());
    private final JobExecutor jobExecutor;
    private final JobImpl<?> job;
    private final boolean addToQueue;

    public JobAddedNotification(JobExecutor jobExecutor, JobImpl<?> job) {
        this.jobExecutor = jobExecutor;
        this.job = job;
        this.addToQueue = this.job.getDueDate().before(new Date()) && this.jobExecutor instanceof AbstractJobExecutor && this.jobExecutor.isActive() && !((AbstractJobExecutor)this.jobExecutor).isLimitSameInstanceJobs();
    }

    public void afterCompletion(int status) {
        if (status == 3) {
            Misc.fastDynamicLog(LOG, Level.FINEST, "notifying jobImpl executor of added message", new Object[0]);
            if (this.addToQueue) {
                ((AbstractJobExecutor)this.jobExecutor).getDispatcherThread().addWaitingJob(this.job);
            } else {
                this.jobExecutor.jobWasAdded();
            }
        }
    }

    public void beforeCompletion() {
        if (this.addToQueue) {
            this.job.setLockExpirationTime(new Date(System.currentTimeMillis() + (long)((AbstractJobExecutor)this.jobExecutor).getLockMillis()));
            this.job.setLockOwner(this.jobExecutor.getName());
        }
    }

    public String toString() {
        return "job-added-notification";
    }
}

