/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.services.jobexecutor;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.orchestra.env.Environment;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.persistence.Transaction;
import org.ow2.orchestra.services.commands.Command;
import org.ow2.orchestra.services.commands.CommandService;
import org.ow2.orchestra.services.commands.RetryInterceptor;
import org.ow2.orchestra.services.job.JobImpl;
import org.ow2.orchestra.services.jobexecutor.AbstractJobExecutor;
import org.ow2.orchestra.services.jobexecutor.DeadJobHandler;
import org.ow2.orchestra.services.jobexecutor.JobAddedNotification;
import org.ow2.orchestra.services.jobexecutor.JobDbSession;
import org.ow2.orchestra.services.jobexecutor.JobExecutor;
import org.ow2.orchestra.util.Misc;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobExceptionHandler
implements Command<Object> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = Logger.getLogger(JobExceptionHandler.class.getName());
    protected final long jobDbid;
    protected final JobImpl<?> failedJob;
    protected final Throwable exception;

    public JobExceptionHandler(long jobDbid, Throwable exception) {
        this.jobDbid = jobDbid;
        this.exception = exception;
        this.failedJob = null;
    }

    public JobExceptionHandler(JobImpl<?> job, Throwable exception) {
        this.jobDbid = job.getDbid();
        this.failedJob = job;
        this.exception = exception;
    }

    @Override
    public Object execute(Environment environment) {
        Misc.fastDynamicLog(LOG, Level.FINE, "handling jobImpl %s exception: %s", this.jobDbid, this.exception);
        JobImpl job = this.failedJob;
        if (job == null) {
            JobDbSession session = environment.get(JobDbSession.class);
            if (session == null) {
                throw new OrchestraRuntimeException("no job-session configured to handle job");
            }
            job = session.get(JobImpl.class, this.jobDbid);
        }
        StringWriter sw = new StringWriter();
        this.exception.printStackTrace(new PrintWriter(sw));
        if (job != null) {
            int decrementedRetries = job.getRetries() - 1;
            Misc.fastDynamicLog(LOG, Level.FINE, "decrementing retries to %s for %s", decrementedRetries, job);
            job.setRetries(decrementedRetries);
            job.setException(sw.toString());
            Misc.fastDynamicLog(LOG, Level.FINE, "unlocking %s", job);
            job.setLockOwner(null);
            job.setLockExpirationTime(null);
            JobExecutor jobExecutor = environment.get(JobExecutor.class);
            if (decrementedRetries == 0) {
                Misc.fastDynamicLog(LOG, Level.SEVERE, "All execution of job %s failed.Last exception was %s", job, job.getException());
                DeadJobHandler deadJobHandler = jobExecutor.getDeadJobHandler();
                if (deadJobHandler != null) {
                    deadJobHandler.handleDeadJob(job);
                }
            } else {
                CommandService commandService;
                long delay = 50L;
                int delayFactor = 2;
                if (jobExecutor instanceof AbstractJobExecutor && (commandService = ((AbstractJobExecutor)jobExecutor).getCommandExecutor()) instanceof RetryInterceptor) {
                    delay = ((RetryInterceptor)commandService).getDelay();
                    delayFactor = ((RetryInterceptor)commandService).getDelayFactor();
                }
                long attemptFactor = job.getDelay() * (long)(1 + RetryInterceptor.getRandom().nextInt(delayFactor - 1));
                job.setDelay(attemptFactor);
                job.setDueDate(new Date(System.currentTimeMillis() + delay * attemptFactor));
                Transaction transaction = environment.get(Transaction.class);
                if (transaction != null && jobExecutor != null) {
                    Misc.fastDynamicLog(LOG, Level.FINEST, "registering job executor notifier with %s", transaction);
                    transaction.registerSynchronization(new JobAddedNotification(jobExecutor, job));
                }
            }
        }
        return null;
    }
}

