/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.services.jobexecutor;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.orchestra.env.Environment;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.persistence.Transaction;
import org.ow2.orchestra.persistence.db.MessageSession;
import org.ow2.orchestra.services.job.MessageImpl;
import org.ow2.orchestra.services.jobexecutor.JobAddedNotification;
import org.ow2.orchestra.services.jobexecutor.JobDbSession;
import org.ow2.orchestra.services.jobexecutor.JobExecutor;
import org.ow2.orchestra.util.Misc;
import org.ow2.orchestra.util.ReflectUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobExecutorMessageSession
implements MessageSession {
    private static final Logger LOG = Logger.getLogger(JobExecutorMessageSession.class.getName());
    private JobDbSession jobDbSession;
    private Transaction transaction;
    private int defaultRetries = 3;
    private boolean useFairScheduling = true;

    @Override
    public void send(MessageImpl<?> message) {
        Misc.fastDynamicLog(LOG, Level.FINE, "sending message %s", ReflectUtil.getUnqualifiedClassName(message.getClass()));
        if (message.isDefaultRetries()) {
            message.setRetries(this.defaultRetries);
        }
        if (!this.useFairScheduling && message.getExecution() != null && message.getDueDate().getTime() <= System.currentTimeMillis()) {
            message.setDueDate(message.getExecution().getProcessInstance().getParentInstanceStartTime());
        }
        this.jobDbSession.save(message);
        Misc.fastDynamicLog(LOG, Level.FINEST, "registering job executor notifier with %s", this.transaction);
        JobExecutor jobExecutor = Environment.getCurrent().get(JobExecutor.class);
        if (jobExecutor == null) {
            throw new OrchestraRuntimeException("no job executor configured to execute " + message);
        }
        this.transaction.registerSynchronization(new JobAddedNotification(jobExecutor, message));
    }

    public void setDefaultRetries(int defaultRetries) {
        this.defaultRetries = defaultRetries;
    }

    public void setUseFairScheduling(boolean useFairScheduling) {
        this.useFairScheduling = useFairScheduling;
    }
}

