/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.services.jobexecutor;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.persistence.Transaction;
import org.ow2.orchestra.persistence.db.TimerSession;
import org.ow2.orchestra.services.job.Timer;
import org.ow2.orchestra.services.job.TimerImpl;
import org.ow2.orchestra.services.jobexecutor.JobAddedNotification;
import org.ow2.orchestra.services.jobexecutor.JobDbSession;
import org.ow2.orchestra.services.jobexecutor.JobExecutor;
import org.ow2.orchestra.util.Misc;

public class JobExecutorTimerSession
implements TimerSession {
    private static final Logger LOG = Logger.getLogger(JobExecutorTimerSession.class.getName());
    private Transaction transaction;
    private JobExecutor jobExecutor;
    private JobDbSession jobDbSession;
    private int defaultRetries = 3;

    public void schedule(TimerImpl timer) {
        Misc.fastDynamicLog(LOG, Level.FINE, "scheduling %s", timer);
        this.validate(timer);
        if (timer.isDefaultRetries()) {
            timer.setRetries(this.defaultRetries);
        }
        this.jobDbSession.save(timer);
        this.transaction.registerSynchronization(new JobAddedNotification(this.jobExecutor, timer));
    }

    protected void validate(Timer timer) {
        if (timer == null) {
            throw new OrchestraRuntimeException("null timer scheduled");
        }
        if (timer.getExecution() == null) {
            throw new OrchestraRuntimeException("timer has no execution specified");
        }
        if (timer.getSignalName() == null) {
            throw new OrchestraRuntimeException("timer has no signalName specified");
        }
        if (timer.getDueDate() == null) {
            throw new OrchestraRuntimeException("timer scheduled at null date");
        }
        if (timer.getDueDate().getTime() < 0L) {
            throw new OrchestraRuntimeException("timer scheduled with a negative date");
        }
    }

    public void cancel(TimerImpl timer) {
        Misc.fastDynamicLog(LOG, Level.FINE, "canceling %s", timer);
        if (timer == null) {
            throw new OrchestraRuntimeException("timer is null");
        }
        this.jobDbSession.delete(timer);
    }

    public void setDefaultRetries(int defaultRetries) {
        this.defaultRetries = defaultRetries;
    }
}

