/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.services.jobexecutor.jdk;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.orchestra.services.job.JobImpl;
import org.ow2.orchestra.services.jobexecutor.AbstractDispatcherThread;
import org.ow2.orchestra.services.jobexecutor.jdk.JdkJobExecutor;
import org.ow2.orchestra.services.jobexecutor.jdk.JobExecutorTask;
import org.ow2.orchestra.util.Misc;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdkDispatcherThread
extends AbstractDispatcherThread {
    private static final Logger LOG = Logger.getLogger(JdkDispatcherThread.class.getName());
    private final JdkJobExecutor jobExecutor;

    JdkDispatcherThread(JdkJobExecutor jobExecutor) {
        this(jobExecutor, "DispatcherThread");
    }

    JdkDispatcherThread(JdkJobExecutor jobExecutor, String name) {
        super(name);
        this.jobExecutor = jobExecutor;
    }

    @Override
    public JdkJobExecutor getJobExecutor() {
        return this.jobExecutor;
    }

    @Override
    protected void putAcquiredJobOnQueue(JobImpl<?> acquiredJob) {
        Misc.fastDynamicLog(LOG, Level.FINE, "pushing job on the queue %s", acquiredJob);
        this.jobExecutor.getExecutorService().submit(new JobExecutorTask(this.jobExecutor.getCommandExecutor(), acquiredJob));
        Misc.fastDynamicLog(LOG, Level.FINEST, "job %s was put on the queue", acquiredJob);
    }
}

