/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.services.jobexecutor.jdk;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.services.jobexecutor.AbstractJobExecutor;
import org.ow2.orchestra.services.jobexecutor.AcquireJobsCmd;
import org.ow2.orchestra.services.jobexecutor.GetNextDueDateCmd;
import org.ow2.orchestra.services.jobexecutor.JobExecutor;
import org.ow2.orchestra.services.jobexecutor.jdk.JdkDispatcherThread;
import org.ow2.orchestra.util.Misc;

public class JdkJobExecutor
extends AbstractJobExecutor
implements JobExecutor {
    private static final Logger LOG = Logger.getLogger(JdkJobExecutor.class.getName());
    private ExecutorService executorService;
    private JdkDispatcherThread dispatcherThread = null;

    public synchronized void start() {
        if (this.commandService == null) {
            throw new OrchestraRuntimeException("no command executor available in jobImpl executor");
        }
        if (!this.isActive) {
            this.acquireJobsCommand = new AcquireJobsCmd(this, this.getName(), this.getLockMillis(), this.isLimitSameInstanceJobs());
            this.nextDueDateCommand = new GetNextDueDateCmd();
            this.isActive = true;
            Misc.fastDynamicLog(LOG, Level.FINEST, "starting jobImpl executor threads for jobImpl executor '" + this.name + "'...", new Object[0]);
            this.executorService = Executors.newCachedThreadPool(new JobExecutorThreadFactory());
            Misc.fastDynamicLog(LOG, Level.FINEST, "starting dispatcher thread for jobImpl executor '" + this.name + "'...", new Object[0]);
            this.dispatcherThread = new JdkDispatcherThread(this);
            this.dispatcherThread.start();
        } else {
            Misc.fastDynamicLog(LOG, Level.FINEST, "ignoring start: jobImpl executor '" + this.name + "' is already started'", new Object[0]);
        }
    }

    public synchronized void stop() {
        this.stop(false);
    }

    public synchronized void stop(boolean join) {
        Misc.fastDynamicLog(LOG, Level.FINEST, "stopping jobImpl executor", new Object[0]);
        if (this.isActive) {
            this.isActive = false;
            this.dispatcherThread.deactivate(true);
            this.executorService.shutdown();
            if (join) {
                this.waitTillQueueEmpty();
            }
        } else {
            Misc.fastDynamicLog(LOG, Level.FINEST, "ignoring stop: jobImpl executor '" + this.name + "' not started", new Object[0]);
        }
    }

    protected void waitTillQueueEmpty() {
        while (!this.executorService.isTerminated()) {
            Misc.fastDynamicLog(LOG, Level.FINEST, "waiting for jobImpl-id-queue to become empty", new Object[0]);
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                Misc.fastDynamicLog(LOG, Level.FINEST, "waiting for jobImpl-id-queue to become empty got interrupted", new Object[0]);
            }
        }
    }

    public JdkDispatcherThread getDispatcherThread() {
        return this.dispatcherThread;
    }

    protected int getAcquireJobSize() {
        return 1;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    private static class JobExecutorThreadFactory
    implements ThreadFactory {
        private final AtomicInteger threadNb = new AtomicInteger();

        private JobExecutorThreadFactory() {
        }

        public Thread newThread(Runnable r) {
            return new Thread(r, "JobExecutorThread-" + this.threadNb.getAndIncrement());
        }
    }
}

