/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.services.jobexecutor.jdk;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.orchestra.services.commands.CommandService;
import org.ow2.orchestra.services.job.JobImpl;
import org.ow2.orchestra.services.jobexecutor.ExecuteJobCmd;
import org.ow2.orchestra.services.jobexecutor.JobExceptionHandler;
import org.ow2.orchestra.util.Misc;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobExecutorTask
implements Runnable {
    private static final Logger LOG = Logger.getLogger(JobExecutorTask.class.getName());
    private final CommandService commandService;
    private final JobImpl<?> job;

    public JobExecutorTask(CommandService commandService, JobImpl<?> job) {
        this.commandService = commandService;
        this.job = job;
    }

    @Override
    public void run() {
        Misc.fastDynamicLog(LOG, Level.FINEST, "job executor task executing job(s) %s", this.job);
        try {
            this.commandService.execute(new ExecuteJobCmd(this.job));
        }
        catch (Exception e) {
            Misc.fastDynamicLog(LOG, Level.FINEST, "exception while executing '%s': %s", this.job, e);
            this.commandService.execute(new JobExceptionHandler(this.job.getDbid(), (Throwable)e));
        }
    }
}

