/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.services.jobexecutor.pvm;

import java.util.concurrent.RejectedExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.orchestra.services.job.JobImpl;
import org.ow2.orchestra.services.jobexecutor.AbstractDispatcherThread;
import org.ow2.orchestra.services.jobexecutor.jdk.JobExecutorTask;
import org.ow2.orchestra.services.jobexecutor.pvm.PvmJobExecutor;
import org.ow2.orchestra.util.Misc;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DispatcherThread
extends AbstractDispatcherThread {
    private static final Logger LOG = Logger.getLogger(DispatcherThread.class.getName());
    private final PvmJobExecutor jobExecutor;

    DispatcherThread(PvmJobExecutor jobExecutor) {
        this(jobExecutor, "DispatcherThread");
    }

    DispatcherThread(PvmJobExecutor jobExecutor, String name) {
        super(name);
        this.jobExecutor = jobExecutor;
    }

    @Override
    protected void putAcquiredJobOnQueue(JobImpl<?> acquiredJob) {
        Misc.fastDynamicLog(LOG, Level.FINE, "pushing job on the queue %s", acquiredJob);
        while (acquiredJob != null) {
            try {
                JobExecutorTask task = new JobExecutorTask(this.jobExecutor.getCommandExecutor(), acquiredJob);
                try {
                    this.jobExecutor.getThreadPool().execute(task);
                }
                catch (RejectedExecutionException e) {
                    this.jobExecutor.getJobTasksQueue().put(task);
                }
                Misc.fastDynamicLog(LOG, Level.FINEST, "job %s was put on the queue", acquiredJob);
                acquiredJob = null;
            }
            catch (InterruptedException e) {
                Misc.fastDynamicLog(LOG, Level.FINEST, "putting acquired job got interrupted. retrying...", new Object[0]);
            }
        }
    }

    @Override
    public PvmJobExecutor getJobExecutor() {
        return this.jobExecutor;
    }
}

