/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.services.jobexecutor.pvm;

import java.lang.reflect.Method;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.services.jobexecutor.AbstractJobExecutor;
import org.ow2.orchestra.services.jobexecutor.AcquireJobsCmd;
import org.ow2.orchestra.services.jobexecutor.GetNextDueDateCmd;
import org.ow2.orchestra.services.jobexecutor.JobExecutor;
import org.ow2.orchestra.services.jobexecutor.pvm.DispatcherThread;
import org.ow2.orchestra.util.Misc;
import org.ow2.orchestra.util.PrefixThreadFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PvmJobExecutor
extends AbstractJobExecutor
implements JobExecutor {
    private static final Logger LOG = Logger.getLogger(PvmJobExecutor.class.getName());
    private int nbrOfThreads = 3;
    private int historySize = 200;
    private ThreadPoolExecutor threadPool;
    private DispatcherThread dispatcherThread = null;
    private LinkedBlockingQueue<Runnable> jobTasksQueue = null;

    @Override
    public synchronized void start() {
        if (this.commandService == null) {
            throw new OrchestraRuntimeException("no command executor available in jobImpl executor");
        }
        if (!this.isActive) {
            this.acquireJobsCommand = new AcquireJobsCmd(this, this.getName(), this.getLockMillis(), this.isLimitSameInstanceJobs());
            this.nextDueDateCommand = new GetNextDueDateCmd();
            this.jobTasksQueue = new LinkedBlockingQueue(2 * this.nbrOfThreads);
            this.isActive = true;
            Misc.fastDynamicLog(LOG, Level.FINEST, "starting jobImpl executor threads for jobImpl executor '" + this.name + "'...", new Object[0]);
            this.threadPool = new ThreadPoolExecutor(this.nbrOfThreads, this.nbrOfThreads, 60L, TimeUnit.SECONDS, this.jobTasksQueue, new PrefixThreadFactory("JobExecutor"));
            try {
                Method m = ThreadPoolExecutor.class.getDeclaredMethod("allowCoreThreadTimeOut", Boolean.TYPE);
                m.invoke((Object)this.threadPool, true);
            }
            catch (Exception exception) {
                // empty catch block
            }
            Misc.fastDynamicLog(LOG, Level.FINEST, "starting dispatcher thread for jobImpl executor '" + this.name + "'...", new Object[0]);
            this.dispatcherThread = new DispatcherThread(this);
            this.dispatcherThread.start();
        } else {
            Misc.fastDynamicLog(LOG, Level.FINEST, "ignoring start: jobImpl executor '" + this.name + "' is already started'", new Object[0]);
        }
    }

    @Override
    public synchronized void stop() {
        this.stop(false);
    }

    @Override
    public synchronized void stop(boolean join) {
        Misc.fastDynamicLog(LOG, Level.FINEST, "stopping jobImpl executor", new Object[0]);
        if (this.isActive) {
            this.isActive = false;
            this.dispatcherThread.deactivate(true);
            this.waitTillQueueEmpty();
            this.threadPool.shutdown();
            if (join) {
                try {
                    this.threadPool.awaitTermination(180L, TimeUnit.SECONDS);
                }
                catch (InterruptedException interruptedException) {}
            }
        } else {
            Misc.fastDynamicLog(LOG, Level.FINEST, "ignoring stop: jobImpl executor '" + this.name + "' not started", new Object[0]);
        }
    }

    protected void waitTillQueueEmpty() {
        while (!this.jobTasksQueue.isEmpty()) {
            Misc.fastDynamicLog(LOG, Level.FINEST, "waiting for jobImpl-id-queue to become empty", new Object[0]);
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                Misc.fastDynamicLog(LOG, Level.FINEST, "waiting for jobImpl-id-queue to become empty got interrupted", new Object[0]);
            }
        }
    }

    protected BlockingQueue<Runnable> getJobTasksQueue() {
        return this.jobTasksQueue;
    }

    @Override
    protected int getAcquireJobSize() {
        return 1;
    }

    public int getHistorySize() {
        return this.historySize;
    }

    public int getNbrOfThreads() {
        return this.nbrOfThreads;
    }

    @Override
    public DispatcherThread getDispatcherThread() {
        return this.dispatcherThread;
    }

    public ThreadPoolExecutor getThreadPool() {
        return this.threadPool;
    }

    public void setNbrOfJobExecutorThreads(int nbrOfJobExecutorThreads) {
        this.nbrOfThreads = nbrOfJobExecutorThreads;
    }

    public void setHistoryMaxSize(int historyMaxSize) {
        this.historySize = historyMaxSize;
    }
}

