/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.util;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.wsdl.Part;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.xml.namespace.QName;
import org.ow2.orchestra.util.XmlUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BpelUtil {
    private BpelUtil() {
    }

    public static boolean isCreateInstance(Element element) {
        String createInstance = XmlUtil.attribute(element, "createInstance");
        return createInstance != null && createInstance.equals("yes");
    }

    public static Map<String, String> getAllNameSpaces(Node n) {
        NamedNodeMap attributes;
        HashMap<String, String> result = new HashMap<String, String>();
        if (n == null) {
            return result;
        }
        if (n.getParentNode() != null) {
            Map<String, String> resultParent = BpelUtil.getAllNameSpaces(n.getParentNode());
            for (Map.Entry<String, String> ns : resultParent.entrySet()) {
                if (result.containsKey(ns.getKey())) continue;
                result.put(ns.getKey(), ns.getValue());
            }
        }
        if ((attributes = n.getAttributes()) != null) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                if (!attributes.item(i).getNodeName().contains("xmlns:")) continue;
                String nodeName = attributes.item(i).getNodeName();
                String prefix = nodeName.split(":")[1];
                result.put(prefix, attributes.item(i).getTextContent());
            }
        }
        result.put("bpel_func", "http://docs.oasis-open.org/wsbpel/2.0/process/executable");
        return result;
    }

    public static ExtensibilityElement findExtensibilityElement(List<ExtensibilityElement> listOfExtensibilityElement, Class<? extends ExtensibilityElement> classToFind) {
        for (ExtensibilityElement extElem : listOfExtensibilityElement) {
            if (!classToFind.isInstance(extElem)) continue;
            return extElem;
        }
        return null;
    }

    public static boolean isXmlSchemaNs(String ns) {
        return ns != null && (ns.equals("http://www.w3.org/2001/XMLSchema") || ns.equals("http://www.w3.org/2001/xml.xsd"));
    }

    public static Document getServiceRefDocument(SOAPAddress address, QName serviceQN) {
        Document document = XmlUtil.getNewDocument();
        Element serviceRef = document.createElementNS("http://docs.oasis-open.org/wsbpel/2.0/serviceref", "service-ref");
        document.appendChild(serviceRef);
        Element epr = document.createElementNS("http://schemas.xmlsoap.org/ws/2004/08/addressing", "EndpointReference");
        serviceRef.appendChild(epr);
        Element addressElement = document.createElementNS("http://schemas.xmlsoap.org/ws/2004/08/addressing", "Address");
        addressElement.setTextContent(address.getLocationURI());
        epr.appendChild(addressElement);
        Element serviceNameElement = document.createElementNS("http://schemas.xmlsoap.org/ws/2004/08/addressing", "ServiceName");
        serviceNameElement.setAttribute("xmlns:eprServicePrefix", serviceQN.getNamespaceURI());
        serviceNameElement.setTextContent("eprServicePrefix:" + serviceQN.getLocalPart());
        epr.appendChild(serviceNameElement);
        return document;
    }

    public static Element getPartElement(Element father, Part part) {
        String partName = part.getName();
        List<Element> childrenElements = XmlUtil.elements(father);
        for (Element child : childrenElements) {
            if (!child.getLocalName().equals(partName)) continue;
            return child;
        }
        return null;
    }

    public static boolean booleanValue(String text, boolean defaultValue) {
        Boolean result = BpelUtil.booleanValue(text);
        if (result == null) {
            return defaultValue;
        }
        return result;
    }

    public static Boolean booleanValue(String text) {
        if (text == null) {
            return null;
        }
        if ("true".equalsIgnoreCase(text) || "enabled".equalsIgnoreCase(text) || "on".equalsIgnoreCase(text) || "yes".equalsIgnoreCase(text)) {
            return Boolean.TRUE;
        }
        if ("false".equalsIgnoreCase(text) || "disabled".equalsIgnoreCase(text) || "off".equalsIgnoreCase(text) || "no".equalsIgnoreCase(text)) {
            return Boolean.FALSE;
        }
        return null;
    }
}

