/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.util;

import java.util.Calendar;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jaxen.dom.DocumentNavigator;
import org.jaxen.function.BooleanFunction;
import org.jaxen.function.StringFunction;
import org.ow2.orchestra.facade.exception.BpelFaultException;
import org.ow2.orchestra.util.Misc;
import org.w3c.dom.Node;

public final class DatatypeUtil {
    private static final Pattern DATE_TIME_PATTERN = Pattern.compile("(-?\\p{Digit}{4,})-(\\p{Digit}{2})-(\\p{Digit}{2})(?:T(\\p{Digit}{2}):(\\p{Digit}{2}):(\\p{Digit}{2})(?:\\.(\\p{Digit}{1,3})\\p{Digit}*)?)?((?:(?:\\+|-)\\p{Digit}{2}:\\p{Digit}{2})|(Z))?");
    private static final Logger LOG = Logger.getLogger(DatatypeUtil.class.getName());

    private DatatypeUtil() {
    }

    public static String toString(Object value) {
        return StringFunction.evaluate(value, DocumentNavigator.getInstance());
    }

    public static String toString(Node node) {
        return StringFunction.evaluate(node, DocumentNavigator.getInstance());
    }

    public static boolean toBoolean(Object value) {
        Boolean bool;
        if (value instanceof Boolean) {
            bool = (Boolean)value;
        } else {
            bool = value instanceof Node ? DatatypeUtil.parseBoolean(DatatypeUtil.toString((Node)value)) : (value instanceof String ? DatatypeUtil.parseBoolean((String)value) : null);
            if (bool == null) {
                bool = BooleanFunction.evaluate(value, DocumentNavigator.getInstance());
            }
        }
        return bool;
    }

    public static Calendar toDateTime(Object value) {
        Calendar dateTime;
        if (value instanceof Calendar) {
            dateTime = (Calendar)value;
        } else {
            dateTime = value instanceof Node ? DatatypeUtil.parseDateTime(DatatypeUtil.toString((Node)value)) : (value instanceof String ? DatatypeUtil.parseDateTime((String)value) : null);
            if (dateTime == null) {
                LOG.finest("cannot interpret value as dateTime: " + value);
                throw BpelFaultException.generateBpelFaultException(BpelFaultException.BpelFault.invalidExpressionValue);
            }
        }
        return dateTime;
    }

    public static Boolean parseBoolean(String text) {
        if (text != null) {
            switch (text.length()) {
                case 1: {
                    switch (text.charAt(0)) {
                        case '0': {
                            return Boolean.FALSE;
                        }
                        case '1': {
                            return Boolean.TRUE;
                        }
                    }
                    break;
                }
                case 4: {
                    if (!"true".equals(text)) break;
                    return Boolean.TRUE;
                }
                case 5: {
                    if (!"false".equals(text)) break;
                    return Boolean.FALSE;
                }
            }
        }
        Misc.fastDynamicLog(LOG, Level.FINEST, "invalid boolean lexical representation: %s", text);
        return null;
    }

    public static Calendar parseDateTime(String text) {
        Matcher matcher = DATE_TIME_PATTERN.matcher(text);
        if (matcher.matches()) {
            Calendar dateTime = Calendar.getInstance();
            dateTime.clear();
            dateTime.set(1, Integer.parseInt(matcher.group(1)));
            dateTime.set(2, Integer.parseInt(matcher.group(2)) - 1);
            dateTime.set(5, Integer.parseInt(matcher.group(3)));
            String group = matcher.group(4);
            if (group != null) {
                dateTime.set(11, Integer.parseInt(group));
                dateTime.set(12, Integer.parseInt(matcher.group(5)));
                dateTime.set(13, Integer.parseInt(matcher.group(6)));
                group = matcher.group(7);
                if (group != null) {
                    dateTime.set(14, Integer.parseInt(group));
                }
            }
            if ((group = matcher.group(8)) != null) {
                TimeZone timeZone = group.equals("Z") ? TimeZone.getTimeZone("GMT+00:00") : TimeZone.getTimeZone("GMT" + group);
                dateTime.setTimeZone(timeZone);
            }
            dateTime.setLenient(false);
            return dateTime;
        }
        Misc.fastDynamicLog(LOG, Level.FINEST, "invalid dateTime lexical representation: %s", text);
        return null;
    }
}

