/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.util;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.hibernate.cfg.Configuration;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.HSQLDialect;
import org.ow2.orchestra.env.DefaultEnvXMLGenerator;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.util.Misc;
import org.ow2.orchestra.util.ReflectUtil;
import org.ow2.orchestra.util.XmlUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class DbTool {
    private DbTool() {
    }

    public static String generateScript(String create, String envXml, String confName, Dialect dialect) throws MalformedURLException, ClassNotFoundException {
        Document doc = XmlUtil.getDocumentFromString(envXml);
        NodeList nl = doc.getElementsByTagName("hibernate-configuration");
        Configuration configuration = new Configuration();
        for (int i = 0; i < nl.getLength(); ++i) {
            List<Element> mappingElts;
            Element confElt = (Element)nl.item(i);
            if (!confName.equals(XmlUtil.attribute(confElt, "name"))) continue;
            List<Element> mappingsElts = XmlUtil.elements(confElt, "mappings");
            if (mappingsElts != null) {
                for (Element element : mappingsElts) {
                    String resourceName = XmlUtil.attribute(element, "resource");
                    Document doc2 = XmlUtil.getDocumentFromInputStream(ReflectUtil.getResourceAsStream(null, resourceName));
                    List<Element> mappingElts2 = XmlUtil.elements(doc2.getDocumentElement(), "mapping");
                    if (mappingElts2 == null) continue;
                    for (Element elt : mappingElts2) {
                        DbTool.addMapping(configuration, elt);
                    }
                }
            }
            if ((mappingElts = XmlUtil.elements(confElt, "mapping")) == null) continue;
            for (Element element : mappingElts) {
                DbTool.addMapping(configuration, element);
            }
        }
        String[] string = null;
        if (create.equals("create")) {
            string = configuration.generateSchemaCreationScript(dialect);
        } else if (create.equals("drop")) {
            string = configuration.generateDropSchemaScript(dialect);
        } else {
            throw new IllegalArgumentException("Invalid type: " + create + ", only 'create' or 'drop' allowed");
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (String s : string) {
            stringBuffer.append(s).append(';').append(Misc.LINE_SEPARATOR);
        }
        return stringBuffer.toString();
    }

    private static void addMapping(Configuration configuration, Element element) throws ClassNotFoundException, MalformedURLException {
        if (element.hasAttribute("resource")) {
            String resource = element.getAttribute("resource");
            configuration.addResource(resource);
        } else if (element.hasAttribute("file")) {
            String fileName = element.getAttribute("file");
            configuration.addFile(fileName);
        } else if (element.hasAttribute("class")) {
            String className = element.getAttribute("class");
            configuration.addClass(Class.forName(className));
        } else if (element.hasAttribute("url")) {
            String urlText = element.getAttribute("url");
            configuration.addURL(new URL(urlText));
        } else {
            Misc.unreachableStatement();
        }
    }

    public static Dialect createDialect(String dialectName) {
        Dialect dialect = (Dialect)ReflectUtil.instantiate(null, dialectName);
        if (dialect instanceof HSQLDialect) {
            ReflectUtil.set(ReflectUtil.getField(HSQLDialect.class, "hsqldbVersion"), dialect, 20);
        }
        return dialect;
    }

    public static void main(String[] args) throws ClassNotFoundException, IOException {
        switch (args.length) {
            case 2: {
                Dialect dialect = DbTool.createDialect(args[1]);
                System.out.println(DbTool.generateScript(args[0], new DefaultEnvXMLGenerator(null, DefaultEnvXMLGenerator.InstallationType.EXTERNAL_JOURNAL_WITH_HISTORY).createEnvironmentXml(), "hibernate-configuration:core", dialect));
                break;
            }
            case 3: {
                Dialect dialect = DbTool.createDialect(args[1]);
                String s = DbTool.generateScript(args[0], new DefaultEnvXMLGenerator(null, DefaultEnvXMLGenerator.InstallationType.EXTERNAL_JOURNAL_WITH_HISTORY).createEnvironmentXml(), "hibernate-configuration:core", dialect);
                Misc.write(s, new File(args[2]));
                break;
            }
            case 4: {
                Dialect dialect = DbTool.createDialect(args[1]);
                String s = DbTool.generateScript(args[0], new DefaultEnvXMLGenerator(null, DefaultEnvXMLGenerator.InstallationType.EXTERNAL_JOURNAL_WITH_HISTORY).createEnvironmentXml(), args[3], dialect);
                Misc.write(s, new File(args[2]));
                break;
            }
            case 5: {
                Dialect dialect = DbTool.createDialect(args[1]);
                String s = DbTool.generateScript(args[0], new String(Misc.getAllContentFrom(new File(args[4]))), args[3], dialect);
                Misc.write(s, new File(args[2]));
                break;
            }
            default: {
                throw new OrchestraRuntimeException("Invalid syntax: " + DbTool.class.getName() + "create dialectClass [outputFile [hibernateConfigName [environmentFileName]]]");
            }
        }
    }
}

