/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.ow2.orchestra.xml.Parse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Namespaces {
    private final Parse parse;
    private Map<String, String> uris = null;

    public Namespaces(Parse parse) {
        this.parse = parse;
    }

    protected void addNamespace(String prefix, String uri) {
        String oldUri;
        if (this.uris == null) {
            this.uris = new HashMap<String, String>();
        }
        if (this.uris.containsKey(prefix) && !(oldUri = this.uris.get(prefix)).equals(uri)) {
            this.parse.addProblem("duplicate definition of namespace prefix: " + prefix + ":" + oldUri + " and " + prefix + ":" + uri);
        }
        this.uris.put(prefix, uri);
    }

    protected void removeNamespace(String prefix) {
        if (this.uris != null) {
            this.uris.remove(prefix);
        }
    }

    public Set<String> addNamespaces(Map<String, String> namespaces) {
        if (namespaces == null) {
            return null;
        }
        HashSet<String> prefixes = new HashSet<String>();
        for (Map.Entry<String, String> ns : namespaces.entrySet()) {
            this.addNamespace(ns.getKey(), ns.getValue());
            prefixes.add(ns.getKey());
        }
        return prefixes;
    }

    public void removePrefixes(Set<String> prefixes) {
        if (prefixes != null && this.uris != null) {
            for (String prefix : prefixes) {
                this.uris.remove(prefix);
            }
        }
    }

    public String getUri(String prefix) {
        if (this.uris != null) {
            return this.uris.get(prefix);
        }
        return null;
    }
}

