/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.ow2.orchestra.definition.activity.AbstractActivity;
import org.ow2.orchestra.definition.element.Copy;
import org.ow2.orchestra.definition.element.Correlation;
import org.ow2.orchestra.definition.element.CorrelationSet;
import org.ow2.orchestra.runtime.BpelExecution;
import org.ow2.orchestra.runtime.CorrelationSetRuntime;
import org.ow2.orchestra.runtime.ScopeRuntime;
import org.ow2.orchestra.runtime.VariableRuntime;
import org.ow2.orchestra.services.MessageCarrier;
import org.ow2.orchestra.services.Receiver;
import org.ow2.orchestra.services.ReceivingElement;
import org.ow2.orchestra.util.Misc;
import org.ow2.orchestra.util.QNameComparator;
import org.ow2.orchestra.var.MessageVariable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ReceivingElementUtil {
    private static final Logger LOG = Logger.getLogger(ReceivingElementUtil.class.getName());

    private ReceivingElementUtil() {
    }

    public static void receive(ReceivingElement receivingElement, MessageVariable message, MessageCarrier messageCarrier, BpelExecution execution) {
        Misc.fastDynamicLog(LOG, Level.FINE, "Receiving message : %s", message);
        ReceivingElementUtil.initiateCs(receivingElement, execution, message);
        if (receivingElement.getVariable() != null) {
            VariableRuntime variableRuntime = execution.getVariableByName(receivingElement.getVariable());
            variableRuntime.setValue(message);
            AbstractActivity activity = execution.getNode().getBehaviour();
            variableRuntime.updated(activity.createRuntimeData(execution));
        } else if (receivingElement.getInCopies() != null && !receivingElement.getInCopies().isEmpty()) {
            ScopeRuntime scopeRuntime = execution.getCurrentScopeRuntime();
            VariableRuntime anonymousInboundMessageVariableRuntime = scopeRuntime.createVariable(execution, receivingElement.getAnonymousInboundMessageVariable());
            anonymousInboundMessageVariableRuntime.setValue(message);
            for (Copy copy : receivingElement.getInCopies()) {
                copy.execute(execution);
            }
            scopeRuntime.removeVariable(execution, receivingElement.getAnonymousInboundMessageVariable());
        }
        Receiver.addReplier(execution, receivingElement, messageCarrier);
    }

    private static void initiateCs(ReceivingElement receivingElement, BpelExecution bpelExecution, MessageVariable incomingMessage) {
        if (receivingElement.getCorrelations() != null) {
            for (Correlation correlation : receivingElement.getCorrelations()) {
                CorrelationSetRuntime correlationSetRuntime = bpelExecution.getCorrelationSetByName(correlation.getCorrelationSet().getName());
                QName messageType = receivingElement.getInputMessageType();
                correlationSetRuntime.checkCSValues(bpelExecution, incomingMessage, messageType, correlation);
            }
        }
    }

    public static void initiateCs(ReceivingElement receivingElement, BpelExecution bpelExecution, CorrelationSet cs, MessageVariable incomingMessage) {
        if (receivingElement.getCorrelations() != null) {
            for (Correlation correlation : receivingElement.getCorrelations()) {
                if (!correlation.getCorrelationSet().equals(cs)) continue;
                CorrelationSetRuntime correlationSetRuntime = bpelExecution.getCorrelationSetByName(correlation.getCorrelationSet().getName());
                QName messageType = receivingElement.getInputMessageType();
                correlationSetRuntime.checkCSValues(bpelExecution, incomingMessage, messageType, correlation);
            }
        }
    }

    public static int getCorrelationPropertiesKey(Map<QName, Document> csProperties) {
        ArrayList<QName> sortedCsNames = new ArrayList<QName>(csProperties.keySet());
        Collections.sort(sortedCsNames, QNameComparator.INSTANCE);
        StringBuilder sb = new StringBuilder();
        for (QName csQnName : sortedCsNames) {
            sb.append(csQnName.toString());
            ReceivingElementUtil.getNormalizedStringFromXML(csProperties.get(csQnName), sb);
        }
        int hashCode = sb.toString().hashCode();
        Misc.fastDynamicLog(LOG, Level.FINE, "Generating hash code for correlation properties: %s", hashCode);
        return hashCode;
    }

    private static void getNormalizedStringFromXML(Node node, StringBuilder stringBuilder) {
        if (node instanceof Element) {
            stringBuilder.append('<').append(node.getLocalName()).append('>');
            NodeList nl = node.getChildNodes();
            for (int i = 0; i < nl.getLength(); ++i) {
                ReceivingElementUtil.getNormalizedStringFromXML(nl.item(i), stringBuilder);
            }
            stringBuilder.append("</").append(node.getLocalName()).append('>');
        } else if (node instanceof Text) {
            stringBuilder.append(node.getTextContent().trim());
        } else if (node instanceof Document) {
            ReceivingElementUtil.getNormalizedStringFromXML(((Document)node).getDocumentElement(), stringBuilder);
        }
    }
}

