/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.util;

import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.orchestra.env.Environment;
import org.ow2.orchestra.env.descriptor.ArgDescriptor;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.util.ArrayUtil;
import org.ow2.orchestra.util.Misc;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ReflectUtil {
    private static final Logger LOG = Logger.getLogger(ReflectUtil.class.getName());

    private ReflectUtil() {
    }

    static ClassLoader resolveClassLoader(ClassLoader classLoader) {
        if (classLoader != null) {
            Misc.fastDynamicLog(LOG, Level.FINEST, "using provided classloader", new Object[0]);
            return classLoader;
        }
        Environment environment = Environment.getCurrent();
        if (environment != null && (classLoader = environment.getClassLoader()) != null) {
            Misc.fastDynamicLog(LOG, Level.FINEST, "using environment classloader", new Object[0]);
            return classLoader;
        }
        Misc.fastDynamicLog(LOG, Level.FINEST, "using context classloader", new Object[0]);
        return Thread.currentThread().getContextClassLoader();
    }

    public static Class<?> loadClass(ClassLoader classLoader, String className) {
        try {
            classLoader = ReflectUtil.resolveClassLoader(classLoader);
            Misc.fastDynamicLog(LOG, Level.FINEST, "loading class %s", className);
            return classLoader.loadClass(className);
        }
        catch (NoClassDefFoundError e) {
            throw new OrchestraRuntimeException("couldn't define class " + className, e);
        }
        catch (ClassNotFoundException e) {
            throw new OrchestraRuntimeException("couldn't load class " + className, e);
        }
    }

    public static InputStream getResourceAsStream(ClassLoader classLoader, String resource) {
        classLoader = ReflectUtil.resolveClassLoader(classLoader);
        Misc.fastDynamicLog(LOG, Level.FINEST, "getting resource as stream %s", resource);
        return classLoader.getResourceAsStream(resource);
    }

    public static Enumeration<URL> getResources(ClassLoader classLoader, String resource) {
        classLoader = ReflectUtil.resolveClassLoader(classLoader);
        try {
            Misc.fastDynamicLog(LOG, Level.FINEST, "getting resources %s", resource);
            return classLoader.getResources(resource);
        }
        catch (Exception e) {
            throw new OrchestraRuntimeException("couldn't get resources " + resource, e);
        }
    }

    public static URL getResource(ClassLoader classLoader, String resource) {
        classLoader = ReflectUtil.resolveClassLoader(classLoader);
        try {
            Misc.fastDynamicLog(LOG, Level.FINEST, "getting resource %s", resource);
            return classLoader.getResource(resource);
        }
        catch (Exception e) {
            throw new OrchestraRuntimeException("couldn't get resource " + resource, e);
        }
    }

    public static Object instantiate(ClassLoader classLoader, String className) {
        Object newObject;
        try {
            classLoader = ReflectUtil.resolveClassLoader(classLoader);
            Class<?> clazz = ReflectUtil.loadClass(classLoader, className);
            Misc.fastDynamicLog(LOG, Level.FINEST, "instantiating %s", className);
            newObject = clazz.newInstance();
        }
        catch (Exception e) {
            throw new OrchestraRuntimeException("couldn't instantiate " + className, e);
        }
        return newObject;
    }

    public static Class<?>[] loadClasses(ClassLoader classLoader, List<String> constructorArgTypeNames) {
        if (constructorArgTypeNames == null) {
            return null;
        }
        Class[] classes = new Class[constructorArgTypeNames.size()];
        for (int i = 0; i < constructorArgTypeNames.size(); ++i) {
            classLoader = ReflectUtil.resolveClassLoader(classLoader);
            classes[i] = ReflectUtil.loadClass(classLoader, constructorArgTypeNames.get(i));
        }
        return classes;
    }

    public static <T> Constructor<T> getConstructor(Class<T> clazz, Class<?>[] parameterTypes) {
        Constructor<T> constructor = null;
        try {
            constructor = clazz.getDeclaredConstructor(parameterTypes);
            Misc.fastDynamicLog(LOG, Level.FINEST, "found constructor %s(%s)", clazz.getName(), ArrayUtil.toString(parameterTypes));
        }
        catch (SecurityException e) {
            throw new OrchestraRuntimeException("wasn't allowed to get constructor '" + clazz.getName() + "(" + ReflectUtil.getParameterTypesText(parameterTypes) + ")'", e);
        }
        catch (NoSuchMethodException e) {
            throw new OrchestraRuntimeException("couldn't find constructor '" + clazz.getName() + "(" + ReflectUtil.getParameterTypesText(parameterTypes) + ")'", e);
        }
        return constructor;
    }

    public static Field getField(Class<?> clazz, String fieldName) {
        return ReflectUtil.getField(clazz, fieldName, clazz);
    }

    private static Field getField(Class<?> clazz, String fieldName, Class<?> original) {
        Field field = null;
        try {
            field = clazz.getDeclaredField(fieldName);
            Misc.fastDynamicLog(LOG, Level.FINEST, "found field %s in %s", fieldName, clazz.getName());
        }
        catch (SecurityException e) {
            throw new OrchestraRuntimeException("wasn't allowed to get field '" + clazz.getName() + "." + fieldName + "'", e);
        }
        catch (NoSuchFieldException e) {
            if (clazz.getSuperclass() != null) {
                return ReflectUtil.getField(clazz.getSuperclass(), fieldName, original);
            }
            throw new OrchestraRuntimeException("couldn't find field '" + original.getName() + "." + fieldName + "'", e);
        }
        return field;
    }

    public static Method getMethod(Class<?> clazz, String methodName, Class<?>[] parameterTypes) {
        return ReflectUtil.getMethod(clazz, methodName, parameterTypes, clazz);
    }

    private static Method getMethod(Class<?> clazz, String methodName, Class<?>[] parameterTypes, Class<?> original) {
        Method method = null;
        try {
            method = clazz.getDeclaredMethod(methodName, parameterTypes);
            Misc.fastDynamicLog(LOG, Level.FINEST, "found method %s.%s(%s)", clazz.getName(), methodName, ArrayUtil.toString(parameterTypes));
        }
        catch (SecurityException e) {
            throw new OrchestraRuntimeException("wasn't allowed to get method '" + clazz.getName() + "." + methodName + "(" + ReflectUtil.getParameterTypesText(parameterTypes) + ")'", e);
        }
        catch (NoSuchMethodException e) {
            if (clazz.getSuperclass() != null) {
                return ReflectUtil.getMethod(clazz.getSuperclass(), methodName, parameterTypes, original);
            }
            throw new OrchestraRuntimeException("couldn't find method '" + original.getName() + "." + methodName + "(" + ReflectUtil.getParameterTypesText(parameterTypes) + ")'", e);
        }
        return method;
    }

    private static String getParameterTypesText(Class<?>[] parameterTypes) {
        if (parameterTypes == null) {
            return "";
        }
        StringBuffer parametersTypeText = new StringBuffer();
        for (int i = 0; i < parameterTypes.length; ++i) {
            Class<?> parameterType = parameterTypes[i];
            parametersTypeText.append(parameterType.getName());
            if (i == parameterTypes.length - 1) continue;
            parametersTypeText.append(", ");
        }
        return parametersTypeText.toString();
    }

    public static <T> T newInstance(Class<T> clazz) {
        return ReflectUtil.newInstance(clazz, null, null);
    }

    public static <T> T newInstance(Constructor<T> constructor) {
        return ReflectUtil.newInstance(null, constructor, null);
    }

    public static <T> T newInstance(Constructor<T> constructor, Object[] args) {
        return ReflectUtil.newInstance(null, constructor, args);
    }

    private static <T> T newInstance(Class<T> clazz, Constructor<T> constructor, Object[] args) {
        if (clazz == null && constructor == null) {
            throw new IllegalArgumentException("can't create new instance without clazz or constructor");
        }
        String className = null;
        try {
            if (constructor == null) {
                Misc.fastDynamicLog(LOG, Level.FINEST, "getting default constructor", new Object[0]);
                constructor = clazz.getConstructor(null);
            }
            className = constructor.getDeclaringClass().getName();
            Misc.fastDynamicLog(LOG, Level.FINEST, "creating new instance for class '%s' with args %s", className, ArrayUtil.toString(args));
            if (!constructor.isAccessible()) {
                Misc.fastDynamicLog(LOG, Level.FINEST, "making constructor accessible", new Object[0]);
                constructor.setAccessible(true);
            }
            return constructor.newInstance(args);
        }
        catch (Exception t) {
            throw new OrchestraRuntimeException("couldn't construct new '" + className + "' with args " + ArrayUtil.toString(args), t);
        }
    }

    public static Object get(Field field, Object object) {
        if (field == null) {
            throw new NullPointerException("field is null");
        }
        try {
            Object value = field.get(object);
            Misc.fastDynamicLog(LOG, Level.FINEST, "got value '%s' from field '%s'", value, field.getName());
            return value;
        }
        catch (Exception e) {
            throw new OrchestraRuntimeException("couldn't get '" + field.getName() + "'", e);
        }
    }

    public static void set(Field field, Object object, Object value) {
        if (field == null) {
            throw new NullPointerException("field is null");
        }
        try {
            Misc.fastDynamicLog(LOG, Level.FINEST, "setting field '%s' to value '%s'", field.getName(), value);
            if (!field.isAccessible()) {
                Misc.fastDynamicLog(LOG, Level.FINEST, "making field accessible", new Object[0]);
                field.setAccessible(true);
            }
            field.set(object, value);
        }
        catch (Exception e) {
            throw new OrchestraRuntimeException("couldn't set '" + field.getName() + "' to '" + value + "'", e);
        }
    }

    public static Object invoke(Method method, Object target, Object[] args) {
        if (method == null) {
            throw new OrchestraRuntimeException("method is null");
        }
        try {
            Misc.fastDynamicLog(LOG, Level.FINEST, "invoking '%s' on '%s' with %s", method.getName(), target, ArrayUtil.toString(args));
            if (!method.isAccessible()) {
                Misc.fastDynamicLog(LOG, Level.FINEST, "making method accessible", new Object[0]);
                method.setAccessible(true);
            }
            return method.invoke(target, args);
        }
        catch (InvocationTargetException e) {
            Throwable targetException = e.getTargetException();
            throw new OrchestraRuntimeException("couldn't invoke '" + method.getName() + "' with " + ArrayUtil.toString(args) + " on " + target + ": " + targetException.getMessage(), targetException);
        }
        catch (Exception e) {
            throw new OrchestraRuntimeException("couldn't invoke '" + method.getName() + "' with " + ArrayUtil.toString(args) + " on " + target + ": " + e.getMessage(), e);
        }
    }

    public static Method findMethod(Class<?> clazz, String methodName, List<ArgDescriptor> argDescriptors, Object[] args) {
        Method[] candidates;
        Misc.fastDynamicLog(LOG, Level.FINEST, "searching for method %s in %s", methodName, clazz.getName());
        for (Method candidate : candidates = clazz.getDeclaredMethods()) {
            if (!candidate.getName().equals(methodName) || !ReflectUtil.isArgumentMatch(candidate.getParameterTypes(), argDescriptors, args)) continue;
            Misc.fastDynamicLog(LOG, Level.FINEST, "found matching method %s.%s", clazz.getName(), methodName);
            return candidate;
        }
        if (clazz.getSuperclass() != null) {
            return ReflectUtil.findMethod(clazz.getSuperclass(), methodName, argDescriptors, args);
        }
        return null;
    }

    public static Constructor<?> findConstructor(Class<?> clazz, List<ArgDescriptor> argDescriptors, Object[] args) {
        Constructor<?>[] constructors;
        for (Constructor<?> constructor : constructors = clazz.getDeclaredConstructors()) {
            if (!ReflectUtil.isArgumentMatch(constructor.getParameterTypes(), argDescriptors, args)) continue;
            return constructor;
        }
        return null;
    }

    public static boolean isArgumentMatch(Class<?>[] parameterTypes, List<ArgDescriptor> argDescriptors, Object[] args) {
        int nbrOfArgs = 0;
        if (args != null) {
            nbrOfArgs = args.length;
        }
        int nbrOfParameterTypes = 0;
        if (parameterTypes != null) {
            nbrOfParameterTypes = parameterTypes.length;
        }
        if (nbrOfArgs == 0 && nbrOfParameterTypes == 0) {
            return true;
        }
        if (nbrOfArgs != nbrOfParameterTypes) {
            return false;
        }
        for (int i = 0; i < parameterTypes.length; ++i) {
            String argTypeName;
            Class<?> parameterType = parameterTypes[i];
            String string = argTypeName = argDescriptors != null ? argDescriptors.get(i).getTypeName() : null;
            if (!(argTypeName != null ? !argTypeName.equals(parameterType.getName()) : args[i] != null && !parameterType.isAssignableFrom(args[i].getClass()))) continue;
            return false;
        }
        return true;
    }

    public static String getSignature(String methodName, List<ArgDescriptor> argDescriptors, Object[] args) {
        StringBuffer buf = new StringBuffer();
        buf.append(methodName).append("(");
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                ArgDescriptor argDescriptor;
                String argType = null;
                if (argDescriptors != null && (argDescriptor = argDescriptors.get(i)) != null && argDescriptor.getTypeName() != null) {
                    argType = argDescriptor.getTypeName();
                }
                if (argType == null && args[i] != null) {
                    argType = args[i].getClass().getName();
                }
                buf.append(argType);
                if (i >= args.length - 1) continue;
                buf.append(", ");
            }
        }
        buf.append(")");
        return buf.toString();
    }

    public static String getUnqualifiedClassName(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        return ReflectUtil.getUnqualifiedClassName(clazz.getSimpleName());
    }

    public static String getUnqualifiedClassName(String className) {
        if (className == null) {
            return null;
        }
        int dotIndex = className.lastIndexOf(46);
        if (dotIndex != -1) {
            className = className.substring(dotIndex + 1);
        }
        return className;
    }
}

