/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.xml.Entity;
import org.xml.sax.InputSource;

public class UrlEntity
implements Entity {
    protected String systemId = null;
    protected URL url = null;

    public UrlEntity(URL url, String systemId) {
        this.url = url;
        this.systemId = systemId;
    }

    public UrlEntity(String resource, ClassLoader classLoader) {
        this.url = classLoader.getResource(resource);
        if (this.url == null) {
            throw new OrchestraRuntimeException("couldn't create Entity from resource " + resource);
        }
        this.systemId = this.url.toString();
    }

    public InputSource getInputSource() {
        try {
            InputStream stream = this.url.openStream();
            InputSource inputSource = new InputSource(stream);
            inputSource.setSystemId(this.systemId);
            return inputSource;
        }
        catch (IOException e) {
            throw new OrchestraRuntimeException("couldn't open stream from url " + this.url, e);
        }
    }
}

