/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.util.stream;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.MalformedURLException;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.util.stream.StreamSource;

public class FileStreamSource
extends StreamSource {
    protected File file;

    public FileStreamSource(File file) {
        if (file == null) {
            throw new OrchestraRuntimeException("file is null");
        }
        try {
            this.name = file.toURI().toURL().toString();
        }
        catch (MalformedURLException e) {
            this.name = file.toString();
        }
        this.file = file;
    }

    public InputStream openStream() {
        FileInputStream stream = null;
        try {
            if (!this.file.exists()) {
                throw new OrchestraRuntimeException("file " + this.file + " doesn't exist");
            }
            if (this.file.isDirectory()) {
                throw new OrchestraRuntimeException("file " + this.file + " is a directory");
            }
            stream = new FileInputStream(this.file);
        }
        catch (Exception e) {
            throw new OrchestraRuntimeException("couldn't access file " + this.file + ": " + e.getMessage(), e);
        }
        return stream;
    }
}

