/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.util.stream;

import java.io.InputStream;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.util.ReflectUtil;
import org.ow2.orchestra.util.stream.StreamSource;

public class ResourceStreamSource
extends StreamSource {
    protected ClassLoader classLoader;
    protected String resource;

    public ResourceStreamSource(String resource) {
        this(resource, null);
    }

    public ResourceStreamSource(String resource, ClassLoader classLoader) {
        if (resource == null) {
            throw new OrchestraRuntimeException("resource is null");
        }
        this.name = "resource://" + resource;
        this.resource = resource;
        this.classLoader = classLoader;
    }

    public InputStream openStream() {
        InputStream stream = ReflectUtil.getResourceAsStream(this.classLoader, this.resource);
        if (stream == null) {
            throw new OrchestraRuntimeException("resource " + this.resource + " does not exist");
        }
        return stream;
    }
}

