/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.var;

import java.util.Map;
import javax.wsdl.Message;
import javax.wsdl.Part;
import javax.xml.namespace.QName;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.facade.runtime.impl.MessageImpl;
import org.ow2.orchestra.util.BpelXmlUtil;
import org.ow2.orchestra.util.XmlUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class MessageVariable
extends MessageImpl {
    private static final long serialVersionUID = -3214634040146001613L;

    protected MessageVariable() {
    }

    public MessageVariable(Document parts) {
        this.parts = parts;
    }

    public MessageVariable(Message wsdlMessage) {
        this.parts = XmlUtil.getNewDocument();
        this.parts.appendChild(this.parts.createElement("message"));
        Map wsdlMessageParts = wsdlMessage.getParts();
        for (Map.Entry entry : wsdlMessageParts.entrySet()) {
            Part part = (Part)entry.getValue();
            String partName = part.getName();
            QName elementQName = part.getElementName();
            QName typeQName = part.getTypeName();
            Element partElement = (Element)this.parts.getDocumentElement().appendChild(this.parts.createElement(partName));
            if (typeQName != null) {
                partElement.appendChild(BpelXmlUtil.createDefaultElement(this.parts));
                continue;
            }
            Element partContent = elementQName.getPrefix() != null && !elementQName.getPrefix().equals("") ? this.parts.createElementNS(elementQName.getNamespaceURI(), elementQName.getPrefix() + ":" + elementQName.getLocalPart()) : this.parts.createElementNS(elementQName.getNamespaceURI(), elementQName.getLocalPart());
            partElement.appendChild(partContent);
            BpelXmlUtil.ensureOwnNamespaceDeclared(partContent);
        }
    }

    public boolean isPartInitialized(String partName) {
        return this.getPartValue(partName) != null;
    }

    public String toString() {
        return XmlUtil.toString(this.parts);
    }

    public MessageVariable duplicate() {
        if (this.parts == null) {
            return null;
        }
        Document duplicateParts = XmlUtil.getNewDocument();
        Node n = duplicateParts.importNode(this.parts.getDocumentElement(), true);
        duplicateParts.appendChild(n);
        return new MessageVariable(duplicateParts);
    }

    public Document getPartsAsDocument() {
        return this.parts;
    }

    public boolean equals(Object anotherMessage) {
        if (anotherMessage == null) {
            return false;
        }
        if (!(anotherMessage instanceof MessageVariable)) {
            return false;
        }
        MessageVariable message = (MessageVariable)anotherMessage;
        return XmlUtil.areNodeEquals(this.parts, message.parts);
    }

    public int hashCode() {
        return this.parts.hashCode();
    }

    public void setPart(String partName, Object value, boolean keepSrcElementName) {
        if (!this.hasPart(partName)) {
            throw new OrchestraRuntimeException("Invalid part name: " + partName);
        }
        Element currentValue = this.getPartValue(partName);
        BpelXmlUtil.setObjectValue(currentValue, value, keepSrcElementName);
    }
}

