/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.wsdl;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.wsdl.Definition;
import javax.wsdl.Import;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.UnknownExtensibilityElement;
import javax.xml.namespace.QName;
import org.ow2.orchestra.definition.BpelProcess;
import org.ow2.orchestra.env.Environment;
import org.ow2.orchestra.exception.StaticAnalysisException;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.lang.PropertyQuery;
import org.ow2.orchestra.lang.evaluator.EvaluatorFactory;
import org.ow2.orchestra.util.BpelUtil;
import org.ow2.orchestra.util.Namespaces;
import org.ow2.orchestra.util.StaticAnalysisFault;
import org.ow2.orchestra.util.XmlUtil;
import org.ow2.orchestra.util.wsdl.WsdlUtil;
import org.ow2.orchestra.wsdl.PartnerLinkType;
import org.ow2.orchestra.wsdl.Property;
import org.ow2.orchestra.wsdl.PropertyAlias;
import org.ow2.orchestra.wsdl.WsdlsInfos;
import org.ow2.orchestra.xml.Parse;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BpelWsdlParser {
    private static Logger log = Logger.getLogger(BpelWsdlParser.class.getName());

    public Definition parse(URL wsdlURL, Parse parse, String processQueryLanguage, BpelProcess bpelProcess, WsdlsInfos wsdlInfos) {
        Definition wsdlDefinition = WsdlUtil.readWsdl(wsdlURL);
        return this.parse(wsdlDefinition, parse, processQueryLanguage, bpelProcess, wsdlInfos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Definition parse(Definition wsdlDefinition, Parse parse, String processQueryLanguage, BpelProcess bpelProcess, WsdlsInfos wsdlInfos) {
        try {
            Namespaces namespaces = parse.findObject(Namespaces.class);
            Set<String> addedPrefixes = namespaces.addNamespaces(wsdlDefinition.getNamespaces());
            ArrayList<Definition> allDefinitions = new ArrayList<Definition>();
            this.retriveAllDefinitions(wsdlDefinition, allDefinitions);
            try {
                wsdlInfos.addWsdlDefinition(wsdlDefinition);
                List<ExtensibilityElement> extensibilityElements = this.getAllExtensibilityElements(allDefinitions);
                if (extensibilityElements != null) {
                    for (ExtensibilityElement extensibilityElement : extensibilityElements) {
                        if (extensibilityElement instanceof UnknownExtensibilityElement) {
                            UnknownExtensibilityElement unknownExtensibilityElement = (UnknownExtensibilityElement)extensibilityElement;
                            QName elementQName = extensibilityElement.getElementType();
                            if (this.isPartnerLinkType(elementQName)) {
                                Element partnerLintTypeElement = unknownExtensibilityElement.getElement();
                                PartnerLinkType partnerLinkType = this.createPartnerLinkType(partnerLintTypeElement, wsdlDefinition.getTargetNamespace(), parse);
                                wsdlInfos.addPartnerLinkType(partnerLinkType);
                                continue;
                            }
                            if (this.isVarProperty(elementQName)) {
                                this.addProperty(wsdlDefinition.getTargetNamespace(), unknownExtensibilityElement, wsdlInfos);
                                continue;
                            }
                            if (this.isVarPropertyAlias(elementQName)) {
                                this.addPropertyAlias(wsdlDefinition.getTargetNamespace(), unknownExtensibilityElement, processQueryLanguage, wsdlInfos, bpelProcess, parse.findObject(Environment.class), parse);
                                continue;
                            }
                            if (!this.isServiceRef(elementQName)) continue;
                            throw new OrchestraRuntimeException("serviceRef not yet implemented !");
                        }
                        if (!log.isLoggable(Level.FINE)) continue;
                        log.fine("unknown extensibility element: " + extensibilityElement);
                    }
                }
            }
            finally {
                namespaces.removePrefixes(addedPrefixes);
            }
        }
        catch (Exception e) {
            parse.addProblem("couldn't parse wsdl " + wsdlDefinition.getDocumentBaseURI(), e);
        }
        return wsdlDefinition;
    }

    private void addProperty(String targetNamespace, UnknownExtensibilityElement prop, WsdlsInfos wsdlInfos) {
        Element propertyElement = prop.getElement();
        String name = propertyElement.getAttribute("name");
        Property property = new Property(new QName(targetNamespace, name));
        property.setType(XmlUtil.attributeQName(propertyElement, "xmlType"));
        property.setElement(XmlUtil.attributeQName(propertyElement, "element"));
        wsdlInfos.addProperty(property);
    }

    private void addPropertyAlias(String targetNamespace, UnknownExtensibilityElement propAlias, String processQueryLanguage, WsdlsInfos wsdlInfos, BpelProcess bpelProcess, Environment environment, Parse parse) {
        Element propertyAliasElement = propAlias.getElement();
        PropertyAlias propertyAlias = new PropertyAlias(XmlUtil.attributeQName(propertyAliasElement, "propertyName"));
        propertyAlias.setMessageType(XmlUtil.attributeQName(propertyAliasElement, "messageType"));
        String partAttributeValue = propertyAliasElement.getAttribute("part");
        if (!"".equals(partAttributeValue)) {
            propertyAlias.setPart(partAttributeValue);
        }
        propertyAlias.setType(XmlUtil.attributeQName(propertyAliasElement, "xmlType"));
        propertyAlias.setElement(XmlUtil.attributeQName(propertyAliasElement, "element"));
        List<Element> queries = XmlUtil.elements(propertyAliasElement, "http://docs.oasis-open.org/wsbpel/2.0/varprop", "query");
        if (queries.size() != 0) {
            Element queryElement = queries.get(0);
            String queryLanguage = XmlUtil.attribute(queryElement, "queryLanguage");
            if (queryLanguage == null) {
                queryLanguage = processQueryLanguage;
            }
            PropertyQuery propertyQuery = new PropertyQuery();
            if (!EvaluatorFactory.isSupportedLanguage(queryLanguage)) {
                String message = StaticAnalysisFault.getMessage("SA00004", "  Query language '" + queryLanguage + "' not supported.");
                parse.addProblem(message, new StaticAnalysisException("SA00004"), queryElement);
                throw new OrchestraRuntimeException(message);
            }
            propertyQuery.setLanguage(queryLanguage);
            propertyQuery.setNamespaces(BpelUtil.getAllNameSpaces(queryElement));
            propertyQuery.setText(queryElement.getTextContent());
            propertyAlias.setQuery(propertyQuery);
        }
        wsdlInfos.addPropertyAlias(propertyAlias);
    }

    protected boolean isPartnerLinkType(QName qn) {
        return "http://docs.oasis-open.org/wsbpel/2.0/plnktype".equals(qn.getNamespaceURI()) && qn.getLocalPart().equals("partnerLinkType");
    }

    protected boolean isServiceRef(QName qn) {
        return "http://docs.oasis-open.org/wsbpel/2.0/serviceref".equals(qn.getNamespaceURI()) && qn.getLocalPart().equals("service-ref");
    }

    protected boolean isVarProperty(QName qn) {
        return "http://docs.oasis-open.org/wsbpel/2.0/varprop".equals(qn.getNamespaceURI()) && qn.getLocalPart().equals("property");
    }

    protected boolean isVarPropertyAlias(QName qn) {
        return "http://docs.oasis-open.org/wsbpel/2.0/varprop".equals(qn.getNamespaceURI()) && qn.getLocalPart().equals("propertyAlias");
    }

    private PartnerLinkType createPartnerLinkType(Element partnerLinkTypeElement, String targetNamespace, Parse parse) {
        String name = partnerLinkTypeElement.getAttribute("name");
        QName partnerLinkTypeName = new QName(targetNamespace, name);
        PartnerLinkType partnerLinkType = new PartnerLinkType(partnerLinkTypeName);
        List<Element> roleElements = XmlUtil.elements(partnerLinkTypeElement, "role");
        if (roleElements != null) {
            for (Element roleElement : roleElements) {
                String roleName = roleElement.getAttribute("name");
                try {
                    XmlUtil.NamespaceValue portTypeValue = XmlUtil.attributeNamespaceValue(roleElement, "portType");
                    String uri = roleElement.lookupNamespaceURI(portTypeValue.getPrefix());
                    QName portTypeQName = new QName(uri, portTypeValue.getLocalPart());
                    partnerLinkType.addRole(roleName, portTypeQName);
                }
                catch (OrchestraRuntimeException e) {
                    parse.addProblem(e.getMessage(), e, roleElement);
                }
            }
        }
        return partnerLinkType;
    }

    private void retriveAllDefinitions(Definition def, List<Definition> allDefinitions) {
        Collection importLists;
        allDefinitions.add(def);
        Map importsMap = def.getImports();
        if (importsMap != null && (importLists = importsMap.values()) != null) {
            for (List importList : importLists) {
                if (importList == null) continue;
                for (Import i : importList) {
                    allDefinitions.add(i.getDefinition());
                    this.retriveAllDefinitions(i.getDefinition(), allDefinitions);
                }
            }
        }
    }

    private List<ExtensibilityElement> getAllExtensibilityElements(List<Definition> definitions) {
        ArrayList<ExtensibilityElement> extensibilityElements = new ArrayList<ExtensibilityElement>();
        for (Definition definition : definitions) {
            extensibilityElements.addAll(definition.getExtensibilityElements());
        }
        return extensibilityElements;
    }
}

