/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.wsdl;

import java.util.List;
import java.util.Set;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.wsdl.extensions.soap.SOAPOperation;
import org.ow2.orchestra.facade.exception.IncompatibleWSDLException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WsdlComparator {
    public static void checkSamePort(Port oldPort, Port newPort) {
        if (!WsdlComparator.nullSafeEquals(oldPort.getName(), newPort.getName())) {
            throw new IncompatibleWSDLException("Port name changed: was " + oldPort.getName() + ", now is " + newPort.getName());
        }
        WsdlComparator.checkSameBinding(oldPort.getBinding(), newPort.getBinding());
    }

    private static void checkSameBinding(Binding oldBinding, Binding newBinding) {
        if (!WsdlComparator.nullSafeEquals(oldBinding.getQName(), newBinding.getQName())) {
            throw new IncompatibleWSDLException("Binding name changed: was " + oldBinding.getQName() + ", now is " + newBinding.getQName());
        }
        WsdlComparator.checkSameSOAPBinding(oldBinding, newBinding);
        if (oldBinding.getBindingOperations().size() != newBinding.getBindingOperations().size()) {
            throw new IncompatibleWSDLException("Binding operation number changed: was " + oldBinding.getBindingOperations().size() + ", now is " + newBinding.getBindingOperations().size());
        }
        for (BindingOperation oldBindingOp : oldBinding.getBindingOperations()) {
            BindingOperation newBindingOp = newBinding.getBindingOperation(oldBindingOp.getName(), oldBindingOp.getBindingInput() != null ? oldBindingOp.getBindingInput().getName() : null, oldBindingOp.getBindingOutput() != null ? oldBindingOp.getBindingOutput().getName() : null);
            if (newBindingOp == null) {
                throw new IncompatibleWSDLException("Binding operation " + oldBindingOp.getName() + " not found.");
            }
            WsdlComparator.checkSameOperationBinding(oldBindingOp, newBindingOp);
        }
        WsdlComparator.checkSamePortType(oldBinding.getPortType(), newBinding.getPortType());
    }

    private static void checkSameOperationBinding(BindingOperation oldBindingOp, BindingOperation newBindingOp) {
        if (oldBindingOp.getBindingInput() != null && newBindingOp.getBindingInput() == null || oldBindingOp.getBindingInput() == null && newBindingOp.getBindingInput() != null) {
            throw new IncompatibleWSDLException("Input binding for operation " + oldBindingOp.getName() + " not found.");
        }
        if (oldBindingOp.getBindingInput() != null) {
            WsdlComparator.checkSameSOAPBody(oldBindingOp.getBindingInput().getExtensibilityElements(), newBindingOp.getBindingInput().getExtensibilityElements());
        }
        if (oldBindingOp.getBindingOutput() != null && newBindingOp.getBindingOutput() == null || oldBindingOp.getBindingOutput() == null && newBindingOp.getBindingOutput() != null) {
            throw new IncompatibleWSDLException("Outut binding for operation " + oldBindingOp.getName() + " not found.");
        }
        if (oldBindingOp.getBindingOutput() != null) {
            WsdlComparator.checkSameSOAPBody(oldBindingOp.getBindingOutput().getExtensibilityElements(), newBindingOp.getBindingOutput().getExtensibilityElements());
        }
        WsdlComparator.checkSameSOAPOperation(oldBindingOp, newBindingOp);
    }

    private static void checkSameSOAPBody(List<ExtensibilityElement> oldExtElements, List<ExtensibilityElement> newExtElements) {
        SOAPBody oldSoapBody = null;
        SOAPBody newSoapBody = null;
        for (ExtensibilityElement oldExtElt : oldExtElements) {
            if (!(oldExtElt instanceof SOAPBody)) continue;
            oldSoapBody = (SOAPBody)oldExtElt;
        }
        for (ExtensibilityElement newExtElt : newExtElements) {
            if (!(newExtElt instanceof SOAPBody)) continue;
            newSoapBody = (SOAPBody)newExtElt;
        }
        if (oldSoapBody == null && newSoapBody != null || oldSoapBody != null && newSoapBody == null || oldSoapBody != null && newSoapBody != null && (!WsdlComparator.nullSafeEquals(oldSoapBody.getEncodingStyles(), newSoapBody.getEncodingStyles()) || !WsdlComparator.nullSafeEquals(oldSoapBody.getUse(), newSoapBody.getUse()) || !WsdlComparator.nullSafeEquals(oldSoapBody.getParts(), newSoapBody.getParts()) || !WsdlComparator.nullSafeEquals(oldSoapBody.getNamespaceURI(), newSoapBody.getNamespaceURI()))) {
            throw new IncompatibleWSDLException("Soap body changed.");
        }
    }

    private static void checkSameSOAPOperation(BindingOperation oldBindingOp, BindingOperation newBindingOp) {
        SOAPOperation oldSoapOperation = null;
        SOAPOperation newSoapOperation = null;
        for (ExtensibilityElement oldExtElt : oldBindingOp.getExtensibilityElements()) {
            if (!(oldExtElt instanceof SOAPOperation)) continue;
            oldSoapOperation = (SOAPOperation)oldExtElt;
        }
        for (ExtensibilityElement newExtElt : newBindingOp.getExtensibilityElements()) {
            if (!(newExtElt instanceof SOAPOperation)) continue;
            newSoapOperation = (SOAPOperation)newExtElt;
        }
        if (oldSoapOperation == null && newSoapOperation != null || oldSoapOperation != null && newSoapOperation == null || oldSoapOperation != null && newSoapOperation != null && (!WsdlComparator.nullSafeEquals(oldSoapOperation.getStyle(), newSoapOperation.getStyle()) || !WsdlComparator.nullSafeEquals(oldSoapOperation.getSoapActionURI(), newSoapOperation.getSoapActionURI()))) {
            throw new IncompatibleWSDLException("Soap operation " + oldBindingOp.getName() + " changed.");
        }
    }

    private static void checkSameSOAPBinding(Binding oldBinding, Binding newBinding) {
        SOAPBinding oldSoapBinding = null;
        SOAPBinding newSoapBinding = null;
        for (ExtensibilityElement oldExtElt : oldBinding.getExtensibilityElements()) {
            if (!(oldExtElt instanceof SOAPBinding)) continue;
            oldSoapBinding = (SOAPBinding)oldExtElt;
        }
        for (ExtensibilityElement newExtElt : newBinding.getExtensibilityElements()) {
            if (!(newExtElt instanceof SOAPBinding)) continue;
            newSoapBinding = (SOAPBinding)newExtElt;
        }
        if (oldSoapBinding == null && newSoapBinding != null || oldSoapBinding != null && newSoapBinding == null || oldSoapBinding != null && newSoapBinding != null && (!WsdlComparator.nullSafeEquals(oldSoapBinding.getStyle(), newSoapBinding.getStyle()) || !WsdlComparator.nullSafeEquals(oldSoapBinding.getTransportURI(), newSoapBinding.getTransportURI()))) {
            throw new IncompatibleWSDLException("Soap binding changed.");
        }
    }

    private static void checkSamePortType(PortType oldPortType, PortType newPortType) {
        if (!WsdlComparator.nullSafeEquals(oldPortType.getQName(), newPortType.getQName())) {
            throw new IncompatibleWSDLException("Binding name changed: was " + oldPortType.getQName() + ", now is " + newPortType.getQName());
        }
        if (oldPortType.getOperations().size() != newPortType.getOperations().size()) {
            throw new IncompatibleWSDLException("PortType operation number changed: was " + oldPortType.getOperations().size() + ", now is " + newPortType.getOperations().size());
        }
        for (Operation oldOp : oldPortType.getOperations()) {
            Operation newOp = newPortType.getOperation(oldOp.getName(), oldOp.getInput() != null ? oldOp.getInput().getName() : null, oldOp.getOutput() != null ? oldOp.getOutput().getName() : null);
            if (newOp == null) {
                throw new IncompatibleWSDLException("PortType operation " + oldOp.getName() + " not found.");
            }
            WsdlComparator.checkSameOperation(oldOp, newOp);
        }
    }

    private static void checkSameOperation(Operation oldOp, Operation newOp) {
        if (oldOp.getInput() != null && newOp.getInput() == null || oldOp.getInput() == null && newOp.getInput() != null) {
            throw new IncompatibleWSDLException("Input for operation " + oldOp.getName() + " not found.");
        }
        if (oldOp.getInput() != null) {
            WsdlComparator.checkSameMessage(oldOp.getInput().getMessage(), newOp.getInput().getMessage());
        }
        if (oldOp.getOutput() != null && newOp.getOutput() == null || oldOp.getOutput() == null && newOp.getOutput() != null) {
            throw new IncompatibleWSDLException("Outut binding for operation " + oldOp.getName() + " not found.");
        }
        if (oldOp.getOutput() != null) {
            WsdlComparator.checkSameMessage(oldOp.getOutput().getMessage(), newOp.getOutput().getMessage());
        }
    }

    private static void checkSameMessage(Message oldMsg, Message newMsg) {
        if (!WsdlComparator.nullSafeEquals(oldMsg.getQName(), newMsg.getQName())) {
            throw new IncompatibleWSDLException("Message name changed: was " + oldMsg.getQName() + ", now is " + newMsg.getQName());
        }
        if (oldMsg.getParts().size() != newMsg.getParts().size()) {
            throw new IncompatibleWSDLException("Message part number changed: was " + oldMsg.getParts().size() + ", now is " + newMsg.getParts().size());
        }
        Set partNames = oldMsg.getParts().keySet();
        for (String partName : partNames) {
            Part oldPart = oldMsg.getPart(partName);
            Part newPart = newMsg.getPart(partName);
            if (newPart == null) {
                throw new IncompatibleWSDLException("Part " + partName + " for message " + oldMsg.getQName() + " not found.");
            }
            if (!WsdlComparator.nullSafeEquals(oldPart.getTypeName(), newPart.getTypeName())) {
                throw new IncompatibleWSDLException("Part " + partName + " type changed: was " + oldPart.getTypeName() + ", now is " + newPart.getTypeName());
            }
            if (WsdlComparator.nullSafeEquals(oldPart.getElementName(), newPart.getElementName())) continue;
            throw new IncompatibleWSDLException("Part " + partName + " element changed: was " + oldPart.getElementName() + ", now is " + newPart.getElementName());
        }
    }

    private static boolean nullSafeEquals(Object obj1, Object obj2) {
        if (obj1 == null) {
            return obj2 == null;
        }
        return obj1.equals(obj2);
    }
}

