/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.wsdl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.xml.namespace.QName;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.util.wsdl.WsdlUtil;
import org.ow2.orchestra.wsdl.PartnerLinkType;
import org.ow2.orchestra.wsdl.Property;
import org.ow2.orchestra.wsdl.PropertyAlias;
import org.ow2.orchestra.wsdl.WsdlInlineUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WsdlsInfos
implements Serializable {
    private static final long serialVersionUID = 2688615599128088745L;
    protected long dbid;
    protected Set<Definition> wsdlDefinitions = new HashSet<Definition>();
    protected Map<QName, PartnerLinkType> partnerLinkTypes;
    protected Map<QName, Property> properties;
    protected List<PropertyAlias> propertyAliases;

    public void addPartnerLinkType(PartnerLinkType partnerLinkType) {
        if (this.partnerLinkTypes == null) {
            this.partnerLinkTypes = new HashMap<QName, PartnerLinkType>();
        }
        this.partnerLinkTypes.put(partnerLinkType.getName(), partnerLinkType);
    }

    public PartnerLinkType getPartnerLinkType(QName partnerLinkTypeName) {
        if (this.partnerLinkTypes != null) {
            return this.partnerLinkTypes.get(partnerLinkTypeName);
        }
        return null;
    }

    public void addWsdlDefinition(Definition wsdlDefinitionToAdd) {
        this.wsdlDefinitions.add(wsdlDefinitionToAdd);
        wsdlDefinitionToAdd.setDocumentBaseURI("wsdl-" + this.wsdlDefinitions.size() + ".wsdl");
        WsdlInlineUtil.inlineWsdlFile(wsdlDefinitionToAdd);
    }

    public PortType getPortType(QName portTypeQName) {
        Definition wsdlDefinition;
        PortType pt = null;
        Iterator<Definition> i$ = this.getWsdlDefinitions().iterator();
        while (i$.hasNext() && (pt = (wsdlDefinition = i$.next()).getPortType(portTypeQName)) == null) {
        }
        return pt;
    }

    public Message getMessage(QName messageName) {
        Definition wsdlDefinition;
        Message msg = null;
        Iterator<Definition> i$ = this.wsdlDefinitions.iterator();
        while (i$.hasNext() && (msg = (wsdlDefinition = i$.next()).getMessage(messageName)) == null) {
        }
        return msg;
    }

    public Service getService(QName serviceName) {
        Definition wsdlDefinition;
        Service service = null;
        Iterator<Definition> i$ = this.wsdlDefinitions.iterator();
        while (i$.hasNext() && (service = (wsdlDefinition = i$.next()).getService(serviceName)) == null) {
        }
        return service;
    }

    public Service getServiceOfPort(Port port) {
        String portName = port.getName();
        for (Definition wsdlDefinition : this.wsdlDefinitions) {
            for (Service service : wsdlDefinition.getServices().values()) {
                if (service.getPort(portName) == null) continue;
                return service;
            }
        }
        return null;
    }

    public List<Service> getServicesOfPortType(QName portTypeQName) {
        List<Service> matchinServices = WsdlUtil.getServicesOfPortType(portTypeQName, this.wsdlDefinitions);
        if (matchinServices.size() > 0) {
            return matchinServices;
        }
        return null;
    }

    public List<Port> getPorts(QName portTypeQName) {
        ArrayList<Port> ports = new ArrayList<Port>();
        for (Definition wsdlDefinition : this.wsdlDefinitions) {
            for (Service service : wsdlDefinition.getServices().values()) {
                Map servicePorts = service.getPorts();
                for (Port port : servicePorts.values()) {
                    if (!port.getBinding().getPortType().getQName().equals(portTypeQName)) continue;
                    ports.add(port);
                }
            }
        }
        return ports;
    }

    public void addProperty(Property property) {
        if (this.properties == null) {
            this.properties = new HashMap<QName, Property>();
        }
        this.properties.put(property.getName(), property);
    }

    public Property getProperty(QName propertyQName) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.get(propertyQName);
    }

    public void addPropertyAlias(PropertyAlias propertyAlias) {
        if (this.propertyAliases == null) {
            this.propertyAliases = new ArrayList<PropertyAlias>();
        }
        this.propertyAliases.add(propertyAlias);
    }

    public PropertyAlias getPropertyAliasWithMessageType(QName propertyName, QName messageType) {
        for (PropertyAlias propertyAlias : this.propertyAliases) {
            if (propertyAlias.getMessageType() == null || !propertyAlias.getMessageType().equals(messageType) || !propertyAlias.getPropertyName().equals(propertyName)) continue;
            return propertyAlias;
        }
        return null;
    }

    public List<PropertyAlias> getPropertyAliasesWithMessageType(QName messageType) {
        ArrayList<PropertyAlias> matchingPropertyAliases = new ArrayList<PropertyAlias>();
        for (PropertyAlias propertyAlias : this.propertyAliases) {
            if (propertyAlias.getMessageType() == null || !propertyAlias.getMessageType().equals(messageType)) continue;
            matchingPropertyAliases.add(propertyAlias);
        }
        return matchingPropertyAliases;
    }

    public List<PropertyAlias> getPropertyAliases(Collection<Property> propertiesToScan, QName messageType) {
        ArrayList<PropertyAlias> result = new ArrayList<PropertyAlias>();
        for (Property property : propertiesToScan) {
            PropertyAlias propertyAlias = this.getPropertyAliasWithMessageType(property.getName(), messageType);
            if (propertyAlias == null) {
                throw new OrchestraRuntimeException("propertyAlias is null, property = " + property);
            }
            result.add(propertyAlias);
        }
        return result;
    }

    public PropertyAlias getPropertyAliasWithElement(QName propertyName, QName element) {
        for (PropertyAlias propertyAlias : this.propertyAliases) {
            if (propertyAlias.getElement() == null || !propertyAlias.getElement().equals(element) || !propertyAlias.getPropertyName().equals(propertyName)) continue;
            return propertyAlias;
        }
        return null;
    }

    public PropertyAlias getPropertyAliasWithType(QName propertyName, QName type) {
        for (PropertyAlias propertyAlias : this.propertyAliases) {
            if (propertyAlias.getType() == null || !propertyAlias.getType().equals(type) || !propertyAlias.getPropertyName().equals(propertyName)) continue;
            return propertyAlias;
        }
        return null;
    }

    public Set<Definition> getWsdlDefinitions() {
        return this.wsdlDefinitions;
    }

    public Definition extractServiceWsdlDefinition(Service service) {
        for (Definition definition : this.wsdlDefinitions) {
            if (definition.getService(service.getQName()) == null) continue;
            return definition;
        }
        return null;
    }

    public Set<Definition> extractServiceWsdlDefinitions(Service service) {
        ServiceWsdlGenerator serviceWsdlGenerator = new ServiceWsdlGenerator(this.wsdlDefinitions);
        return serviceWsdlGenerator.generateWsdlsForService(service);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ServiceWsdlGenerator {
        private final Set<Definition> wsdlDefinitions;

        public ServiceWsdlGenerator(Set<Definition> wsdlDefinitions) {
            this.wsdlDefinitions = wsdlDefinitions;
        }

        public Set<Definition> generateWsdlsForService(Service service) {
            HashSet<Definition> defs = new HashSet<Definition>();
            this.addServiceToDefinitions(defs, service);
            return defs;
        }

        private void addServiceToDefinitions(Set<Definition> definitions, Service service) {
            for (Definition definition : this.wsdlDefinitions) {
                if (definition.getService(service.getQName()) == null) continue;
                definitions.add(definition);
            }
            Map ports = service.getPorts();
            for (Port port : ports.values()) {
                Binding binding = port.getBinding();
                this.addBindingToDefinition(definitions, binding);
            }
        }

        private void addBindingToDefinition(Set<Definition> definitions, Binding binding) {
            for (Definition definition : this.wsdlDefinitions) {
                if (definition.getBinding(binding.getQName()) == null) continue;
                definitions.add(definition);
            }
            PortType portType = binding.getPortType();
            this.addPortTypeToDefinition(definitions, portType);
        }

        private void addPortTypeToDefinition(Set<Definition> definitions, PortType portType) {
            for (Definition definition : this.wsdlDefinitions) {
                if (definition.getPortType(portType.getQName()) == null) continue;
                definitions.add(definition);
            }
            List operations = portType.getOperations();
            for (Operation operation : operations) {
                Map faults;
                Message outputMessage;
                Output output;
                Message inputMessage;
                Input input = operation.getInput();
                if (input != null && (inputMessage = input.getMessage()) != null) {
                    this.addMessageToDefinition(definitions, inputMessage);
                }
                if ((output = operation.getOutput()) != null && (outputMessage = output.getMessage()) != null) {
                    this.addMessageToDefinition(definitions, outputMessage);
                }
                if ((faults = operation.getFaults()) == null) continue;
                for (Fault fault : faults.values()) {
                    Message faultMessage = fault.getMessage();
                    this.addMessageToDefinition(definitions, faultMessage);
                }
            }
        }

        private void addMessageToDefinition(Set<Definition> definitions, Message message) {
            for (Definition definition : this.wsdlDefinitions) {
                if (definition.getMessage(message.getQName()) == null) continue;
                definitions.add(definition);
            }
        }
    }
}

