/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.xml;

import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.orchestra.facade.exception.ParsingException;
import org.ow2.orchestra.util.Misc;
import org.ow2.orchestra.util.XmlUtil;
import org.ow2.orchestra.util.stream.FileStreamSource;
import org.ow2.orchestra.util.stream.ResourceStreamSource;
import org.ow2.orchestra.util.stream.StreamSource;
import org.ow2.orchestra.util.stream.UrlStreamSource;
import org.ow2.orchestra.xml.Binding;
import org.ow2.orchestra.xml.Bindings;
import org.ow2.orchestra.xml.Entity;
import org.ow2.orchestra.xml.ExtendedDOMParser;
import org.ow2.orchestra.xml.Parse;
import org.ow2.orchestra.xml.Problem;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Parser
implements EntityResolver {
    private static final Logger LOG = Logger.getLogger(Parser.class.getName());
    private static final String NEWLINE = System.getProperty("line.separator");
    protected Map<String, Entity> entities = null;
    protected Bindings bindings = null;
    protected ClassLoader classLoader = null;
    static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    static final String JAXP_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";

    public Parser() {
    }

    public Parser(Bindings bindings) {
        this.bindings = bindings;
    }

    public Parser(Bindings bindings, Map<String, Entity> entities) {
        this.bindings = bindings;
        this.entities = entities;
    }

    public void addEntity(String publicId, Entity entity) {
        if (this.entities == null) {
            this.entities = new HashMap<String, Entity>();
        }
        this.entities.put(publicId, entity);
    }

    public void useParseEntityResolver() {
        if (this.entities == null) {
            this.entities = new HashMap<String, Entity>();
        }
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) {
        Entity entity;
        InputSource inputSource = null;
        if (this.entities != null && (entity = this.entities.get(publicId)) != null) {
            inputSource = entity.getInputSource();
        }
        if (inputSource == null) {
            if (systemId != null) {
                inputSource = new InputSource(systemId);
            } else {
                Misc.fastDynamicLog(LOG, Level.SEVERE, "couldn't resolve entity with publicId " + publicId + " and null systemId", new Object[0]);
            }
        }
        return inputSource;
    }

    public Bindings getBindings() {
        return this.bindings;
    }

    public void setBindings(Bindings bindings) {
        this.bindings = bindings;
    }

    public Binding getBinding(Element element) {
        return this.getBinding(element, null);
    }

    public Binding getBinding(Element element, String category) {
        return this.bindings != null ? this.bindings.getBinding(element, category) : null;
    }

    public Parse createParse() {
        return new Parse(this);
    }

    public void importStream(StreamSource importedStreamSource, Element destination, Parse importingParse) {
        try {
            Parse importedParse = this.createParse();
            importedParse.setStreamSource(importedStreamSource);
            Document importedDocument = this.buildDom(importedParse);
            Element importedDocumentElement = importedDocument.getDocumentElement();
            for (Element e : XmlUtil.elements(importedDocumentElement)) {
                destination.appendChild(destination.getOwnerDocument().importNode(e, true));
            }
        }
        catch (Exception e) {
            importingParse.addProblem("couldn't import " + importedStreamSource, e);
        }
    }

    public void importExternalReferences(Element element, Parse parse) {
        StreamSource streamSource = null;
        if (element.hasAttribute("file")) {
            String fileName = element.getAttribute("file");
            File file = new File(fileName);
            if (file.exists() && file.isFile()) {
                streamSource = new FileStreamSource(file);
            } else {
                parse.addProblem("file " + fileName + " isn't a file", element.getAttributeNode("file"));
            }
        }
        if (element.hasAttribute("resource")) {
            String resource = element.getAttribute("resource");
            streamSource = new ResourceStreamSource(resource, parse.getClassLoader());
        }
        if (element.hasAttribute("url")) {
            String urlText = element.getAttribute("url");
            try {
                URL url = new URL(urlText);
                streamSource = new UrlStreamSource(url);
            }
            catch (Exception e) {
                parse.addProblem("couldn't open url " + urlText, e, element.getAttributeNode("url"));
            }
        }
        if (streamSource != null) {
            this.importStream(streamSource, element, parse);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute(Parse parse) {
        try {
            if (parse.document == null) {
                parse.document = this.buildDom(parse);
            }
            if (parse.document != null) {
                try {
                    this.parseDocument(parse.document, parse);
                }
                catch (Exception e) {
                    parse.addProblem("couldn't interpret the dom model", e);
                }
            }
        }
        finally {
            if (parse.inputStream != null) {
                try {
                    parse.inputStream.close();
                }
                catch (Exception e) {
                    parse.addProblem("couldn't close input stream", e);
                }
            }
        }
    }

    protected String[] getSchemaSources() {
        return null;
    }

    protected Document buildDom(Parse parse) {
        ExtendedDOMParser parser = new ExtendedDOMParser();
        InputSource inputSource = this.getInputSource(parse);
        try {
            parser.setFeature("http://apache.org/xml/features/dom/defer-node-expansion", false);
            parser.setFeature("http://xml.org/sax/features/external-general-entities", true);
            parser.setFeature("http://xml.org/sax/features/external-parameter-entities", true);
            parser.setFeature("http://apache.org/xml/features/dom/create-entity-ref-nodes", true);
            parser.setProperty(JAXP_SCHEMA_LANGUAGE, W3C_XML_SCHEMA);
            String[] schemaSources = this.getSchemaSources();
            if (schemaSources != null) {
                parser.setFeature("http://xml.org/sax/features/validation", true);
                parser.setFeature("http://apache.org/xml/features/validation/schema", true);
                parser.setProperty(JAXP_SCHEMA_SOURCE, schemaSources);
            }
            parser.setEntityResolver(this);
            parser.setErrorHandler(parse);
            parser.parse(inputSource);
            parse.setDocument(parser.getDocument());
        }
        catch (Exception e) {
            parse.addProblem("couldn't build DOM", e);
        }
        return parse.getDocument();
    }

    protected InputSource getInputSource(Parse parse) {
        if (parse.inputSource != null) {
            return parse.inputSource;
        }
        if (parse.streamSource != null) {
            parse.inputStream = parse.streamSource.openStream();
            return new InputSource(parse.inputStream);
        }
        parse.addProblem("no source specified to parse");
        return null;
    }

    public Object parseDocument(Document document, Parse parse) {
        Object object;
        parse.documentObject = object = this.parseDocumentElement(document.getDocumentElement(), parse);
        return object;
    }

    public Object parseDocumentElement(Element documentElement, Parse parse) {
        return this.parseElement(documentElement, parse);
    }

    public Object parseElement(Element element, Parse parse) {
        return this.parseElement(element, parse, null);
    }

    public Object parseElement(Element element, Parse parse, String category) {
        Object object = null;
        String tagName = XmlUtil.getTagLocalName(element);
        Binding binding = this.getBinding(element, category);
        if (binding != null) {
            object = binding.parse(element, parse, this);
        } else {
            parse.addProblem("no element parser for tag " + tagName + (category != null ? " in category " + category : " in the default category"), element);
        }
        return object;
    }

    public void checkProblems(String description, Parse parse) {
        if (parse.hasProblems()) {
            StringBuffer errorMsg = null;
            for (Problem p : parse.getProblems()) {
                if (p.getSeverity().equals("error") || p.getSeverity().equals("fatal-error")) {
                    if (errorMsg == null) {
                        errorMsg = new StringBuffer();
                    }
                    errorMsg.append(NEWLINE);
                    errorMsg.append("  ");
                    errorMsg.append(p.toString());
                    if (p.getCause() != null) {
                        Misc.fastDynamicLog(LOG, Level.SEVERE, p.toString() + Misc.LINE_SEPARATOR + Misc.getStackTraceFrom(p.getCause()), new Object[0]);
                        continue;
                    }
                    Misc.fastDynamicLog(LOG, Level.SEVERE, p.toString(), new Object[0]);
                    continue;
                }
                if (p.getSeverity().equals("warning")) {
                    Misc.fastDynamicLog(LOG, Level.WARNING, p.toString(), new Object[0]);
                    continue;
                }
                Misc.fastDynamicLog(LOG, Level.INFO, p.toString(), new Object[0]);
            }
            if (errorMsg != null) {
                throw new ParsingException("errors during parsing of " + description + ": " + errorMsg);
            }
        }
    }
}

