/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.axis;

import org.apache.axis.AxisFault;
import org.apache.axis.MessageContext;
import org.apache.axis.description.OperationDesc;
import org.apache.axis.handlers.soap.SOAPService;
import org.apache.axis.providers.java.MsgProvider;
import org.ow2.orchestra.axis.ClassLoaderMap;
import org.ow2.orchestra.axis.WebServiceClassLoader;

public class ProcessMsgProvider
extends MsgProvider {
    private static final long serialVersionUID = 5240751552526750450L;
    private static final String METHOD_BODYARRAY = "soapbodyelement";
    private static final String METHOD_ELEMENTARRAY = "element";
    private static final String METHOD_DOCUMENT = "document";

    protected void setOperationStyle(MessageContext msgContext) {
        OperationDesc operation = msgContext.getOperation();
        if (operation == null || operation.getMessageOperationStyle() > -1) {
            return;
        }
        int methodType = operation.getMessageOperationStyle();
        String methodSignature = operation.getMethod().toString().toLowerCase();
        methodType = methodSignature.indexOf(METHOD_BODYARRAY) != -1 ? 1 : (methodSignature.indexOf(METHOD_ELEMENTARRAY) != -1 ? 3 : (methodSignature.indexOf(METHOD_DOCUMENT) != -1 ? 4 : 2));
        operation.setMessageOperationStyle(methodType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(MessageContext msgContext) throws AxisFault {
        this.setOperationStyle(msgContext);
        String endpointName = msgContext.getService().getName();
        WebServiceClassLoader cl = ClassLoaderMap.getCL(endpointName);
        msgContext.setClassLoader(cl);
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(cl.getOrchestraClassLoader());
            super.invoke(msgContext);
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    public void initServiceDesc(SOAPService service, MessageContext msgContext) throws AxisFault {
        String endpointName = service.getName();
        WebServiceClassLoader cl = ClassLoaderMap.getCL(endpointName);
        if (msgContext != null) {
            msgContext.setClassLoader(cl);
        }
        super.initServiceDesc(service, msgContext);
    }
}

