/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.test.correlation.simpleCorrelation;

import java.util.HashMap;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import org.ow2.orchestra.pvm.env.Environment;
import org.ow2.orchestra.pvm.internal.cmd.Command;
import org.ow2.orchestra.pvm.internal.cmd.CommandService;
import org.ow2.orchestra.test.BpelTestCase;
import org.ow2.orchestra.util.BpelXmlUtil;
import org.w3c.dom.Element;

public class SimpleCorrelationTest
extends BpelTestCase {
    public SimpleCorrelationTest() {
        super("http://example.com/simpleCorrelation", "simpleCorrelation");
    }

    public void testSimpleCorrelation() {
        this.deploy();
        this.launch();
        this.undeploy();
    }

    public void deploy() {
        this.deploy(((Object)((Object)this)).getClass().getResource(this.getProcessName() + ".bpel"), ((Object)((Object)this)).getClass().getResource(this.getProcessName() + ".wsdl"));
    }

    public long launch() {
        String auctionId = "1";
        String shippingCosts1 = "1";
        HashMap<String, Element> parts = new HashMap<String, Element>();
        parts.put("shippingCosts", BpelXmlUtil.createElementWithContent((String)"1"));
        parts.put("auctionId", BpelXmlUtil.createElementWithContent((String)"1"));
        String shippingCosts2 = "2";
        HashMap<String, Element> parts2 = new HashMap<String, Element>();
        parts2.put("shippingCosts", BpelXmlUtil.createElementWithContent((String)"2"));
        parts2.put("auctionId", BpelXmlUtil.createElementWithContent((String)"1"));
        QName portTypeQName = new QName(this.getProcessNamespace(), this.getProcessName() + "PT");
        String operationName = "submit";
        final BpelTestCase.CallResult callResult = this.call(parts, portTypeQName, "create");
        this.call(parts, portTypeQName, "submit");
        this.call(parts2, portTypeQName, "submit");
        this.waitForInstanceEnd(callResult.getProcessInstanceUUID());
        long endTime = System.currentTimeMillis();
        CommandService commandService = (CommandService)this.getEnvironmentFactory().get(CommandService.class);
        commandService.execute((Command)new Command<Object>(){

            public Object execute(Environment environment) throws Exception {
                Assert.assertNotNull(callResult.getVariables());
                Assert.assertEquals((int)1, (int)callResult.getVariables().size());
                String expected1 = "1-1-1-2";
                String expected2 = "1-2-1-1";
                Object result = SimpleCorrelationTest.this.getVariableValue(callResult, "result");
                if (!SimpleCorrelationTest.this.assertResult(result, "1-1-1-2") && !SimpleCorrelationTest.this.assertResult(result, "1-2-1-1")) {
                    Assert.assertTrue((String)("wrong correlation, expected was either 1-1-1-2, either 1-2-1-1and the result is " + result), (boolean)false);
                }
                Assert.assertTrue((boolean)true);
                SimpleCorrelationTest.this.deleteInstance(callResult);
                return null;
            }
        });
        return endTime;
    }

    private boolean assertResult(Object o, String expected) {
        Assert.assertNotNull((Object)o);
        Assert.assertTrue((String)"result is not an instance of Element", (boolean)(o instanceof Element));
        Element result = (Element)o;
        boolean b = expected.equals(result.getTextContent());
        return b;
    }
}

