/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.test.jmx;

import java.util.HashMap;
import java.util.UUID;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import org.ow2.orchestra.facade.InstanceManagementAPI;
import org.ow2.orchestra.facade.exception.InstanceNotFoundException;
import org.ow2.orchestra.facade.uuid.IdFactory;
import org.ow2.orchestra.facade.uuid.ProcessInstanceUUID;
import org.ow2.orchestra.jmx.RemoteDeployerImpl;
import org.ow2.orchestra.pvm.env.Environment;
import org.ow2.orchestra.pvm.internal.cmd.Command;
import org.ow2.orchestra.pvm.internal.cmd.CommandService;
import org.ow2.orchestra.test.BpelTestCase;
import org.ow2.orchestra.test.WSRepository;
import org.ow2.orchestra.test.wsutils.SaveWS;
import org.ow2.orchestra.util.BpelXmlUtil;
import org.w3c.dom.Element;

public class InstanceManagementExitTest
extends BpelTestCase {
    private static final InstanceManagementAPI REMOTEDEPLOYER = new RemoteDeployerImpl();
    private final long time = 3L;

    public InstanceManagementExitTest() {
        super("http://orchestra.ow2.org/ExitTest", "ExitTest");
    }

    public void deploy() {
        this.deploy(((Object)((Object)this)).getClass().getResource(this.getProcessName() + ".bpel"), ((Object)((Object)this)).getClass().getResource(this.getProcessName() + ".wsdl"));
    }

    public Object[] launch(String message, SaveWS saveWS) {
        WSRepository.addWS(SaveWS.PORTTYPE_QNAME, saveWS);
        HashMap<String, Element> parts = new HashMap<String, Element>();
        parts.put("duration", BpelXmlUtil.createElementWithContent((String)("PT" + this.time + "S")));
        parts.put("message", BpelXmlUtil.createElementWithContent((String)message));
        QName portTypeQName = new QName(this.getProcessNamespace(), this.getProcessName() + "PortType");
        String operationName = "ExitTestOperation";
        final BpelTestCase.CallResult callResult = this.call(parts, portTypeQName, "ExitTestOperation");
        CommandService commandService = (CommandService)this.getEnvironmentFactory().get(CommandService.class);
        ProcessInstanceUUID processInstanceUUID = (ProcessInstanceUUID)commandService.execute((Command)new Command<ProcessInstanceUUID>(){

            public ProcessInstanceUUID execute(Environment environment) throws Exception {
                return callResult.getInstance().getProcessInstanceUUID();
            }
        });
        return new Object[]{processInstanceUUID, callResult};
    }

    private void deleteInstanceMethod(final BpelTestCase.CallResult callResult) {
        CommandService commandService = (CommandService)this.getEnvironmentFactory().get(CommandService.class);
        commandService.execute((Command)new Command<Object>(){

            public Object execute(Environment environment) throws Exception {
                InstanceManagementExitTest.this.deleteInstance(callResult);
                return null;
            }
        });
    }

    public void testInstance() {
        this.deploy();
        String message = UUID.randomUUID().toString();
        String expectedResponse = message + message;
        SaveWS saveWS = new SaveWS();
        Object[] result = this.launch(message, saveWS);
        this.waitForInstanceEnd((ProcessInstanceUUID)result[0]);
        WSRepository.removeWS(SaveWS.PORTTYPE_QNAME);
        this.deleteInstanceMethod((BpelTestCase.CallResult)result[1]);
        this.undeploy();
        Assert.assertEquals((String)expectedResponse, (String)saveWS.getBuffer());
    }

    public void testExitInstance() {
        this.deploy();
        String message = UUID.randomUUID().toString();
        String expectedResponse = message + message;
        SaveWS saveWS = new SaveWS();
        Object[] result = this.launch(message, saveWS);
        try {
            REMOTEDEPLOYER.exit((ProcessInstanceUUID)result[0]);
        }
        catch (InstanceNotFoundException e) {
            Assert.fail((String)e.getMessage());
        }
        this.waitForInstanceEnd((ProcessInstanceUUID)result[0]);
        WSRepository.removeWS(SaveWS.PORTTYPE_QNAME);
        this.deleteInstanceMethod((BpelTestCase.CallResult)result[1]);
        this.undeploy();
        if (expectedResponse.equals(saveWS.getBuffer())) {
            Assert.fail((String)"The process should not have ended ...");
        }
    }

    public void testExitExitedInstance() {
        this.deploy();
        String message = UUID.randomUUID().toString();
        String expectedResponse = message + message;
        SaveWS saveWS = new SaveWS();
        Object[] result = this.launch(message, saveWS);
        try {
            REMOTEDEPLOYER.exit((ProcessInstanceUUID)result[0]);
            REMOTEDEPLOYER.exit((ProcessInstanceUUID)result[0]);
        }
        catch (InstanceNotFoundException e) {
            Assert.fail((String)e.getMessage());
        }
        this.waitForInstanceEnd((ProcessInstanceUUID)result[0]);
        WSRepository.removeWS(SaveWS.PORTTYPE_QNAME);
        this.deleteInstanceMethod((BpelTestCase.CallResult)result[1]);
        this.undeploy();
        if (expectedResponse.equals(saveWS.getBuffer())) {
            Assert.fail((String)"The process should not have ended ...");
        }
    }

    public void testExitBadInstance() {
        try {
            REMOTEDEPLOYER.exit(IdFactory.getNewInstanceUUID());
            Assert.fail((String)"The instance should not have been found.");
        }
        catch (InstanceNotFoundException e) {
            Assert.assertNotNull((Object)((Object)e));
        }
    }
}

