/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.test.activities.foreach;

import java.util.Arrays;
import java.util.HashMap;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import org.ow2.orchestra.facade.exception.BpelFaultException;
import org.ow2.orchestra.pvm.env.Environment;
import org.ow2.orchestra.pvm.internal.cmd.Command;
import org.ow2.orchestra.pvm.internal.cmd.CommandService;
import org.ow2.orchestra.test.BpelTestCase;
import org.ow2.orchestra.util.BpelXmlUtil;
import org.ow2.orchestra.var.MessageVariable;
import org.w3c.dom.Element;

public class ParallelForEachTest
extends BpelTestCase {
    public ParallelForEachTest() {
        super("http://orchestra.ow2.org/parallelForeach", "parallelForeach");
    }

    public void testParallelForEach() {
        this.deploy();
        this.launch(1, 3, false);
        this.undeploy();
    }

    public void testCountParallelForEach() {
        this.deploy();
        this.launch(1, 4, true);
        this.undeploy();
    }

    public void testCountParallelForEachNegative() {
        this.deploy();
        BpelFaultException e = this.launchInvalid(-2, 1, true);
        Assert.assertNotNull((String)"InvalidExpressionValue expected", (Object)e);
        Assert.assertEquals((Object)BpelFaultException.BpelFault.invalidExpressionValue.getQName(), (Object)e.getFaultName());
        this.undeploy();
    }

    public void testCountParallelForEachStartNotOne() {
        this.deploy();
        this.launch(3, 4, true);
        this.undeploy();
    }

    public void testEqualsCountParallelForEach() {
        this.deploy();
        this.launch(3, 3, true);
        this.undeploy();
    }

    public void testGreaterCountParallelForEach() {
        this.deploy();
        this.launch(6, 4, true);
        this.undeploy();
    }

    public void deploy() {
        this.deploy(((Object)((Object)this)).getClass().getResource(this.getProcessName() + ".bpel"), ((Object)((Object)this)).getClass().getResource(this.getProcessName() + ".wsdl"));
    }

    public long launch(final int start, int stop, final boolean verifyCount) {
        int i;
        final int callCount = Math.max(0, stop - start + 1);
        BpelTestCase.CallResult[] callResults = new BpelTestCase.CallResult[callCount];
        QName portTypeQName = new QName(this.getProcessNamespace(), this.getProcessName() + "PT");
        String operationName = "start";
        HashMap<String, Element> parts = new HashMap<String, Element>();
        parts.put("start", BpelXmlUtil.createElementWithContent((String)Integer.toString(start)));
        parts.put("stop", BpelXmlUtil.createElementWithContent((String)Integer.toString(stop)));
        final BpelTestCase.CallResult callResult = this.call(parts, portTypeQName, operationName);
        operationName = "initiate";
        for (i = 0; i < callCount; ++i) {
            parts = new HashMap();
            parts.put("auctionId", BpelXmlUtil.createElementWithContent((String)Integer.toString(i)));
            parts.put("id", BpelXmlUtil.createElementWithContent((String)Integer.toString(callCount - i)));
            this.call(parts, portTypeQName, operationName);
        }
        operationName = "submit";
        for (i = 0; i < callCount; ++i) {
            parts = new HashMap();
            parts.put("auctionId", BpelXmlUtil.createElementWithContent((String)Integer.toString(callCount - i - 1)));
            callResults[i] = this.call(parts, portTypeQName, operationName);
            MessageVariable reply = callResults[i].getMessageCarrier().getMessage();
            Assert.assertEquals((int)(i + 1), (int)Integer.parseInt(reply.getPartValue("id").getTextContent()));
            Assert.assertEquals((int)(i + 1), (int)Integer.parseInt(reply.getPartValue("time").getTextContent()));
        }
        long endTime = System.currentTimeMillis();
        CommandService commandService = (CommandService)this.getEnvironmentFactory().get(CommandService.class);
        commandService.execute((Command)new Command<Object>(){
            private static final long serialVersionUID = 1624305940767648609L;

            public Object execute(Environment environment) throws Exception {
                if (verifyCount) {
                    int i;
                    MessageVariable reply = callResult.getMessageCarrier().getMessage();
                    String[] counts = reply.getPartValue("count").getTextContent().split(",");
                    Assert.assertTrue((boolean)counts[0].equals("s"));
                    int[] countValues = new int[callCount];
                    Assert.assertEquals((int)(callCount + 1), (int)counts.length);
                    for (i = 1; i < counts.length; ++i) {
                        countValues[i - 1] = Integer.parseInt(counts[i]);
                    }
                    Arrays.sort(countValues);
                    for (i = 0; i < callCount; ++i) {
                        Assert.assertEquals((int)(start + i), (int)countValues[i]);
                    }
                }
                ParallelForEachTest.this.deleteInstance(callResult);
                return null;
            }
        });
        return endTime;
    }

    public BpelFaultException launchInvalid(int start, int stop, boolean verifyCount) {
        int i;
        int callCount = Math.max(0, stop - start + 1);
        BpelTestCase.CallResult[] callResults = new BpelTestCase.CallResult[callCount];
        QName portTypeQName = new QName(this.getProcessNamespace(), this.getProcessName() + "PT");
        String operationName = "start";
        HashMap<String, Element> parts = new HashMap<String, Element>();
        parts.put("start", BpelXmlUtil.createElementWithContent((String)Integer.toString(start)));
        parts.put("stop", BpelXmlUtil.createElementWithContent((String)Integer.toString(stop)));
        BpelTestCase.CallResult callResult = this.call(parts, portTypeQName, operationName);
        operationName = "initiate";
        for (i = 0; i < callCount; ++i) {
            parts = new HashMap();
            parts.put("auctionId", BpelXmlUtil.createElementWithContent((String)Integer.toString(i)));
            parts.put("id", BpelXmlUtil.createElementWithContent((String)Integer.toString(callCount - i)));
            this.call(parts, portTypeQName, operationName);
        }
        operationName = "submit";
        for (i = 0; i < callCount; ++i) {
            parts = new HashMap();
            parts.put("auctionId", BpelXmlUtil.createElementWithContent((String)Integer.toString(callCount - i - 1)));
            callResults[i] = this.call(parts, portTypeQName, operationName);
        }
        BpelFaultException exception = this.waitForExceptionInInstance(callResult.getProcessInstanceUUID(), BpelFaultException.class);
        this.deleteInstances(1);
        return exception;
    }
}

