/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.test.partnerLink.partnerLink;

import java.net.URL;
import java.util.HashMap;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import org.ow2.orchestra.pvm.env.Environment;
import org.ow2.orchestra.pvm.internal.cmd.Command;
import org.ow2.orchestra.pvm.internal.cmd.CommandService;
import org.ow2.orchestra.runtime.PartnerLinkRuntime;
import org.ow2.orchestra.test.BpelTestCase;
import org.ow2.orchestra.util.XmlUtil;
import org.ow2.orchestra.var.MessageVariable;
import org.w3c.dom.Element;

public class PartnerLinkTest
extends BpelTestCase {
    public PartnerLinkTest() {
        super("http://example.com/partnerLink", "partnerLink");
    }

    public void testPartnerLink() {
        this.deploy();
        this.launch();
        this.undeploy();
    }

    public void deploy() {
        this.deploy(((Object)((Object)this)).getClass().getResource(this.getProcessName() + ".bpel"), ((Object)((Object)this)).getClass().getResource(this.getProcessName() + ".wsdl"));
    }

    public long launch() {
        URL epr1 = ((Object)((Object)this)).getClass().getResource("epr1.xml");
        this.assertExists(epr1);
        HashMap<String, Element> parts = new HashMap<String, Element>();
        parts.put("epr1", XmlUtil.getDocumentFromURL((URL)epr1).getDocumentElement());
        QName portTypeQName = new QName(this.getProcessNamespace(), this.getProcessName() + "PT");
        String operationName = "submit";
        final BpelTestCase.CallResult callResult = this.call(parts, portTypeQName, "submit");
        this.waitForInstanceEnd(callResult.getProcessInstanceUUID());
        long endTime = System.currentTimeMillis();
        CommandService commandService = (CommandService)this.getEnvironmentFactory().get(CommandService.class);
        commandService.execute((Command)new Command<Object>(){

            public Object execute(Environment environment) throws Exception {
                Assert.assertNotNull(callResult.getPartnerLInks());
                Assert.assertEquals((int)4, (int)callResult.getPartnerLInks().size());
                Assert.assertNotNull(callResult.getVariables());
                Assert.assertEquals((int)10, (int)callResult.getVariables().size());
                PartnerLinkTest.this.assertPartnerLink(PartnerLinkTest.this.getPartnerLink(callResult, "partnerLinkPL2"));
                PartnerLinkTest.this.assertPartnerLink(PartnerLinkTest.this.getPartnerLink(callResult, "partnerLinkPL3"));
                PartnerLinkTest.this.assertPartnerLink(PartnerLinkTest.this.getPartnerLink(callResult, "partnerLinkPL4"));
                PartnerLinkTest.this.assertPartnerLink(PartnerLinkTest.this.getPartnerLink(callResult, "partnerLinkPL5"));
                PartnerLinkTest.this.assertMessage(PartnerLinkTest.this.getVariableValue(callResult, "request1"));
                PartnerLinkTest.this.assertMessage(PartnerLinkTest.this.getVariableValue(callResult, "request2"));
                PartnerLinkTest.this.assertMessage(PartnerLinkTest.this.getVariableValue(callResult, "request3"));
                PartnerLinkTest.this.assertMessage(PartnerLinkTest.this.getVariableValue(callResult, "request4"));
                PartnerLinkTest.this.assertMessage(PartnerLinkTest.this.getVariableValue(callResult, "request5"));
                PartnerLinkTest.this.assertEprVariable(PartnerLinkTest.this.getVariableValue(callResult, "epr1"));
                PartnerLinkTest.this.assertEprVariable(PartnerLinkTest.this.getVariableValue(callResult, "epr2"));
                PartnerLinkTest.this.assertEprVariable(PartnerLinkTest.this.getVariableValue(callResult, "epr3"));
                PartnerLinkTest.this.assertEprVariable(PartnerLinkTest.this.getVariableValue(callResult, "epr4"));
                PartnerLinkTest.this.assertEprVariable(PartnerLinkTest.this.getVariableValue(callResult, "epr5"));
                PartnerLinkTest.this.deleteInstance(callResult);
                return null;
            }
        });
        return endTime;
    }

    private void assertPartnerLink(PartnerLinkRuntime partnerLink) {
        Assert.assertNotNull((Object)partnerLink);
        this.assertServiceRefElement(partnerLink.getPartnerRoleEndPointReference());
    }

    private void assertServiceRefElement(Object o) {
        this.assertServiceRefElement(o, "http://localhost:9999/partnerLinkService", new QName(this.getProcessNamespace(), "partnerLinkService"));
    }

    private void assertServiceRefType(Object o) {
        this.assertServiceRefType(o, "http://localhost:9999/partnerLinkService", new QName(this.getProcessNamespace(), "partnerLinkService"));
    }

    private void assertEprVariable(Object o) {
        this.assertServiceRefType(o);
    }

    private void assertMessage(Object o) {
        Assert.assertNotNull((Object)o);
        Assert.assertTrue((String)"o is not an instance of Message", (boolean)(o instanceof MessageVariable));
        Element epr1 = ((MessageVariable)o).getPartValue("epr1");
        Assert.assertNotNull((Object)epr1);
        this.assertServiceRefType(epr1);
        Element epr2 = ((MessageVariable)o).getPartValue("epr2");
        Assert.assertNotNull((Object)epr2);
        this.assertServiceRefElement(epr2);
    }
}

