/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.test.remote.fail;

import java.util.Set;
import java.util.UUID;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPMessage;
import junit.framework.Assert;
import org.ow2.orchestra.facade.def.ProcessDefinition;
import org.ow2.orchestra.facade.exception.BpelFaultException;
import org.ow2.orchestra.facade.exception.FaultWithMessage;
import org.ow2.orchestra.facade.jmx.RemoteDeployerMBean;
import org.ow2.orchestra.facade.runtime.ActivityInstance;
import org.ow2.orchestra.facade.runtime.ActivityState;
import org.ow2.orchestra.facade.runtime.ProcessInstance;
import org.ow2.orchestra.test.remote.RemoteTestCase;
import org.ow2.orchestra.util.Misc;
import org.ow2.orchestra.util.SOAPUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InvokerFaultTest
extends RemoteTestCase {
    private static final String PROCESS_NAME = "failBpel";
    private static final String PROCESS_NAMESPACE = "http://orchestra.ow2.org/failBpel";
    private static final QName PROCESS_QNAME = new QName("http://orchestra.ow2.org/failBpel", "failBpel");
    private static final QName FAIL_SERVICE_QNAME = new QName("tns:http://orchestra.ow2.org/failService/failService", "failService");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInvokerFaultTransformation() throws Exception {
        Thread t = null;
        this.deploy(FAIL_SERVICE_QNAME.getLocalPart());
        ProcessDefinition processDefinition = this.deploy(PROCESS_NAME);
        try {
            String random = UUID.randomUUID().toString();
            String part = "<failBpelRequest xmlns='http://orchestra.ow2.org/failBpel'>" + random + "</failBpelRequest>";
            String processEndpoint = this.getDefaultEndpoint("failBpelPort");
            SOAPMessage request = SOAPUtil.buildDocumentSOAPMessage((String)PROCESS_NAMESPACE, (String)part);
            SOAPMessage responded = SOAPUtil.call((SOAPMessage)request, (String)processEndpoint);
            this.waitForExceptionInInstance(processDefinition, FaultWithMessage.class, new QName("tns:http://orchestra.ow2.org/failService/failService", "FailServiceFailure"));
            Assert.assertNotNull((Object)responded);
            Assert.assertTrue((boolean)responded.getSOAPBody().hasFault());
            Assert.assertTrue((boolean)responded.getSOAPBody().getFault().getFaultString().contains("No reply message available"));
        }
        finally {
            if (t != null) {
                t.interrupt();
            }
        }
        this.undeploy(PROCESS_QNAME);
        this.undeploy(FAIL_SERVICE_QNAME);
    }

    public <E extends BpelFaultException> E waitForExceptionInInstance(ProcessDefinition processDefinition, Class<E> exceptionClass, QName faultName) throws Exception {
        long pollInterval = 1000L;
        long timeout = 180000L;
        long startTime = System.currentTimeMillis();
        RemoteDeployerMBean remoteDeployer = (RemoteDeployerMBean)Misc.getMBeanProxy(RemoteDeployerMBean.class, (String)this.jmxServiceUrl, (String)this.jmxObjectName);
        while (startTime + 180000L > System.currentTimeMillis()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            Set processInstances = remoteDeployer.findProcessInstances(processDefinition.getProcessDefinitionUUID());
            for (ProcessInstance processInstance : processInstances) {
                if (processInstance.getState().equals((Object)ActivityState.RUNNING)) continue;
                Set activityInstances = remoteDeployer.findActivityInstances(processInstance.getProcessInstanceUUID());
                for (ActivityInstance activityInstance : activityInstances) {
                    BpelFaultException exception = activityInstance.getLastException();
                    if (exception == null) continue;
                    if (!exceptionClass.isInstance(exception)) {
                        Assert.fail((String)("Exception is instance of " + exception.getClass().getName() + ". Expecting " + exceptionClass.getName()));
                        continue;
                    }
                    if (faultName != null) {
                        Assert.assertEquals((Object)faultName, (Object)exception.getFaultName());
                    }
                    return (E)((BpelFaultException)exceptionClass.cast(exception));
                }
            }
        }
        Assert.fail((String)"Exception not detected when timeout occured.");
        return null;
    }
}

