/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.test.jmx;

import java.util.HashMap;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import org.ow2.orchestra.facade.InstanceManagementAPI;
import org.ow2.orchestra.facade.exception.InstanceNotFoundException;
import org.ow2.orchestra.facade.uuid.ProcessInstanceUUID;
import org.ow2.orchestra.jmx.RemoteDeployerImpl;
import org.ow2.orchestra.pvm.env.Environment;
import org.ow2.orchestra.pvm.internal.cmd.Command;
import org.ow2.orchestra.pvm.internal.cmd.CommandService;
import org.ow2.orchestra.test.BpelTestCase;
import org.ow2.orchestra.test.activities.wait.WaitForTest;
import org.ow2.orchestra.util.BpelXmlUtil;
import org.w3c.dom.Element;

public class InstanceManagementTerminatedTest
extends BpelTestCase {
    private static final InstanceManagementAPI REMOTEDEPLOYER = new RemoteDeployerImpl();

    public InstanceManagementTerminatedTest() {
        super("http://example.com/waitFor", "waitFor");
    }

    public void deploy() {
        this.deploy(WaitForTest.class.getResource(this.getProcessName() + ".bpel"), WaitForTest.class.getResource(this.getProcessName() + ".wsdl"));
    }

    public Object[] launch() {
        HashMap<String, Element> parts = new HashMap<String, Element>();
        parts.put("duration", BpelXmlUtil.createElementWithContent((String)"PT1S"));
        QName portTypeQName = new QName(this.getProcessNamespace(), this.getProcessName() + "PT");
        String operationName = "submit";
        final BpelTestCase.CallResult callResult = this.call(parts, portTypeQName, operationName);
        CommandService commandService = (CommandService)this.getEnvironmentFactory().get(CommandService.class);
        ProcessInstanceUUID processInstanceUUID = (ProcessInstanceUUID)commandService.execute((Command)new Command<ProcessInstanceUUID>(){

            public ProcessInstanceUUID execute(Environment environment) {
                return callResult.getInstance().getProcessInstanceUUID();
            }
        });
        return new Object[]{processInstanceUUID, callResult};
    }

    private void deleteInstanceMethod(final BpelTestCase.CallResult callResult) {
        CommandService commandService = (CommandService)this.getEnvironmentFactory().get(CommandService.class);
        commandService.execute((Command)new Command<Object>(){

            public Object execute(Environment environment) {
                InstanceManagementTerminatedTest.this.deleteInstance(callResult);
                return null;
            }
        });
    }

    public void testExitTerminatedInstance() {
        this.deploy();
        Object[] result = this.launch();
        this.waitForInstanceEnd((ProcessInstanceUUID)result[0]);
        try {
            REMOTEDEPLOYER.exit((ProcessInstanceUUID)result[0]);
        }
        catch (InstanceNotFoundException e) {
            Assert.fail((String)e.getMessage());
        }
        this.deleteInstanceMethod((BpelTestCase.CallResult)result[1]);
        this.undeploy();
    }

    public void testSuspendTerminatedInstance() {
        this.deploy();
        Object[] result = this.launch();
        this.waitForInstanceEnd((ProcessInstanceUUID)result[0]);
        try {
            REMOTEDEPLOYER.suspend((ProcessInstanceUUID)result[0]);
        }
        catch (InstanceNotFoundException e) {
            Assert.fail((String)e.getMessage());
        }
        this.deleteInstanceMethod((BpelTestCase.CallResult)result[1]);
        this.undeploy();
    }

    public void testResumeTerminatedInstance() {
        this.deploy();
        Object[] result = this.launch();
        this.waitForInstanceEnd((ProcessInstanceUUID)result[0]);
        try {
            REMOTEDEPLOYER.resume((ProcessInstanceUUID)result[0]);
        }
        catch (InstanceNotFoundException e) {
            Assert.fail((String)e.getMessage());
        }
        this.deleteInstanceMethod((BpelTestCase.CallResult)result[1]);
        this.undeploy();
    }
}

