/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression;

import java.io.IOException;
import java.sql.SQLException;
import org.h2.expression.ParameterInterface;
import org.h2.message.Message;
import org.h2.value.Transfer;
import org.h2.value.Value;

public class ParameterRemote
implements ParameterInterface {
    private Value value;
    private int index;
    private int dataType = -1;
    private long precision;
    private int scale;
    private int nullable = 2;

    public ParameterRemote(int n) {
        this.index = n;
    }

    public void setValue(Value value, boolean bl) throws SQLException {
        if (bl && this.value != null) {
            this.value.close();
        }
        this.value = value;
    }

    public Value getParamValue() {
        return this.value;
    }

    public void checkSet() throws SQLException {
        if (this.value == null) {
            throw Message.getSQLException(90012, "#" + (this.index + 1));
        }
    }

    public int getType() {
        return this.value == null ? this.dataType : this.value.getType();
    }

    public long getPrecision() {
        return this.value == null ? this.precision : this.value.getPrecision();
    }

    public int getScale() {
        return this.value == null ? this.scale : this.value.getScale();
    }

    public int getNullable() {
        return this.nullable;
    }

    public void readMetaData(Transfer transfer) throws IOException {
        this.dataType = transfer.readInt();
        this.precision = transfer.readLong();
        this.scale = transfer.readInt();
        this.nullable = transfer.readInt();
    }

    public static void writeMetaData(Transfer transfer, ParameterInterface parameterInterface) throws IOException {
        transfer.writeInt(parameterInterface.getType());
        transfer.writeLong(parameterInterface.getPrecision());
        transfer.writeInt(parameterInterface.getScale());
        transfer.writeInt(parameterInterface.getNullable());
    }
}

