/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.facade.data.runtime;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.ow2.orchestra.facade.data.runtime.ScopeUpdateData;
import org.ow2.orchestra.facade.uuid.ActivityInstanceUUID;
import org.ow2.orchestra.util.XmlUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CorrelationSetInitializedData
extends ScopeUpdateData {
    private String name;
    private Map<QName, Node> propertyValues;

    public CorrelationSetInitializedData(ActivityInstanceUUID scopeActivityUUID, ActivityInstanceUUID activityInstanceUUID, String name, Map<QName, Node> propertyValues) {
        super(scopeActivityUUID, activityInstanceUUID);
        this.name = name;
        this.propertyValues = propertyValues;
    }

    public String getName() {
        return this.name;
    }

    public Map<QName, Node> getPropertyValues() {
        return this.propertyValues;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.name);
        out.writeObject(this.propertyValues.size());
        for (Map.Entry<QName, Node> entry : this.propertyValues.entrySet()) {
            out.writeObject(entry.getKey().toString());
            Node node = entry.getValue();
            Element el = node.getOwnerDocument().createElementNS("http://orchestra.ow2.org", "Orchestra_BPEL_Prefix:ORCHESTRA_anonymous_element");
            el.appendChild(node);
            ByteArrayOutputStream byteStream = XmlUtil.getNodeAsBAOS(el);
            out.writeObject(byteStream.toString());
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.name = (String)in.readObject();
        int size = (Integer)in.readObject();
        this.propertyValues = new HashMap<QName, Node>(size);
        for (int i = 0; i < size; ++i) {
            QName key = QName.valueOf((String)in.readObject());
            Node value = XmlUtil.getDocumentFromString((String)in.readObject()).getDocumentElement().getFirstChild();
            this.propertyValues.put(key, value);
        }
    }
}

