/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.test.remote;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.soap.Node;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPMessage;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.ow2.orchestra.facade.Deployment;
import org.ow2.orchestra.facade.def.ProcessDefinition;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.facade.jmx.RemoteDeployerMBean;
import org.ow2.orchestra.util.DeploymentUtil;
import org.ow2.orchestra.util.Misc;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteTestCase
extends TestCase {
    private static final Logger LOG = Logger.getLogger(RemoteTestCase.class.getName());
    protected Properties orchestraProperties = new Properties();
    protected String jmxServiceUrl;
    protected String jmxObjectName;

    public RemoteTestCase() {
        try {
            this.orchestraProperties.load(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("orchestra.properties"));
        }
        catch (IOException e) {
            throw new OrchestraRuntimeException((Throwable)e);
        }
        this.jmxServiceUrl = this.orchestraProperties.getProperty("orchestra.jmx.serviceUrl");
        this.jmxObjectName = this.orchestraProperties.getProperty("orchestra.jmx.objectName");
    }

    protected ProcessDefinition deploy(String processName) {
        return this.deploy(processName, null);
    }

    protected ProcessDefinition deploy(String processName, List<URL> wsdls) {
        return this.deploy(((Object)((Object)this)).getClass().getResource(processName + ".bpel"), wsdls);
    }

    protected ProcessDefinition deploy(URL bpel, URL wsdl) {
        ArrayList<URL> wsdls = new ArrayList<URL>();
        wsdls.add(wsdl);
        return this.deploy(bpel, wsdls);
    }

    protected ProcessDefinition deploy(URL bpel, List<URL> wsdls) {
        return this.deploy(bpel, wsdls, null);
    }

    protected ProcessDefinition deploy(URL bpel, List<URL> wsdls, Map<String, byte[]> resources) {
        Deployment bpelDeployment = DeploymentUtil.generateDeployment((URL)bpel, wsdls);
        if (resources != null) {
            bpelDeployment.getResourcesRepository().getResources().putAll(resources);
        }
        try {
            RemoteDeployerMBean remoteDeployer = (RemoteDeployerMBean)Misc.getMBeanProxy(RemoteDeployerMBean.class, (String)this.jmxServiceUrl, (String)this.jmxObjectName);
            ProcessDefinition processDefinition = remoteDeployer.deploy(bpelDeployment);
            Assert.assertNotNull((Object)processDefinition);
            return processDefinition;
        }
        catch (Exception e) {
            throw new OrchestraRuntimeException((Throwable)e);
        }
    }

    protected void undeploy(QName processQName) {
        try {
            RemoteDeployerMBean remoteDeployer = (RemoteDeployerMBean)Misc.getMBeanProxy(RemoteDeployerMBean.class, (String)this.jmxServiceUrl, (String)this.jmxObjectName);
            Assert.assertTrue((boolean)remoteDeployer.undeploy(processQName));
        }
        catch (Exception e) {
            throw new OrchestraRuntimeException((Throwable)e);
        }
    }

    protected SOAPBodyElement getSOAPBodyElement(SOAPMessage response) {
        if (response == null) {
            throw new OrchestraRuntimeException("response is null");
        }
        try {
            SOAPBody soapBody = response.getSOAPBody();
            if (soapBody == null) {
                throw new OrchestraRuntimeException("response.soapBody is null");
            }
            Iterator it = soapBody.getChildElements();
            SOAPBodyElement result = null;
            while (it.hasNext()) {
                Node item = (Node)it.next();
                if (!(item instanceof SOAPBodyElement)) continue;
                if (result != null) {
                    throw new OrchestraRuntimeException("response.soapBody.children has more than one child");
                }
                result = (SOAPBodyElement)item;
            }
            if (result == null) {
                throw new OrchestraRuntimeException("response.soapBody.children has no child");
            }
            return result;
        }
        catch (Exception e) {
            throw new OrchestraRuntimeException("Exception caught while getting soapBodyElement of message : " + response, (Throwable)e);
        }
    }

    protected String getDefaultEndpoint(String portName) {
        String endpoint = "http://" + this.orchestraProperties.getProperty("orchestra.servlet.host") + ":" + this.orchestraProperties.getProperty("orchestra.servlet.port") + "/" + this.orchestraProperties.getProperty("orchestra.servlet.path") + "/" + portName;
        return endpoint;
    }

    protected String[] getStaticClusterEndpoint(String portName) {
        String[] endpoint;
        String urls = this.orchestraProperties.getProperty("clustersUrls");
        if (urls == null) {
            endpoint = new String[]{};
        } else {
            String[] listUrlCluster = urls.split(";");
            int nbMachine = listUrlCluster.length;
            endpoint = new String[nbMachine];
            for (int i = 0; i < nbMachine; ++i) {
                endpoint[i] = listUrlCluster[i] + "/" + this.orchestraProperties.getProperty("orchestra.servlet.path") + "/" + portName;
            }
        }
        return endpoint;
    }

    protected void tearDown() throws Exception {
        LOG.log(Level.INFO, "=== ending " + this.getName() + " =============================\n");
        super.tearDown();
    }

    public void setUp() throws Exception {
        LOG.log(Level.INFO, "=== starting " + this.getName() + " =============================\n");
    }
}

