/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.jmxclient;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Properties;
import javax.naming.ServiceUnavailableException;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.jmxclient.ClientAction;
import org.ow2.orchestra.jmxclient.ClientOptions;
import org.ow2.orchestra.jmxclient.DeployAction;
import org.ow2.orchestra.jmxclient.DeployBarAction;
import org.ow2.orchestra.jmxclient.GetProcessAction;
import org.ow2.orchestra.jmxclient.InitAction;
import org.ow2.orchestra.jmxclient.LaunchAction;
import org.ow2.orchestra.jmxclient.ListInstanceAction;
import org.ow2.orchestra.jmxclient.ListProcessAction;
import org.ow2.orchestra.jmxclient.StatusAction;
import org.ow2.orchestra.jmxclient.UndeployAction;
import org.ow2.orchestra.util.Misc;

public final class JMXClient {
    static String jmxServiceUrl;
    static String jmxObjectName;

    private JMXClient() {
    }

    private static void printHelp(String description, Options opts) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.setSyntaxPrefix("");
        System.out.println();
        System.out.println(description + ":");
        formatter.printHelp("java -jar orchestra-jmxclient.jar", opts, true);
        System.out.println();
    }

    public static void main(String[] args) {
        block23: {
            try {
                InputStream orchestraPropsStream;
                String propertiesLocation = System.getProperty("orchestra.properties");
                if (propertiesLocation != null) {
                    try {
                        orchestraPropsStream = new FileInputStream(propertiesLocation);
                    }
                    catch (FileNotFoundException e) {
                        throw new OrchestraRuntimeException("Cannot load orchestra.properties from " + propertiesLocation);
                    }
                } else {
                    orchestraPropsStream = JMXClient.class.getClassLoader().getResourceAsStream("orchestra.properties");
                    if (orchestraPropsStream == null) {
                        System.out.println("orchestra.properties not found in classpath.");
                        System.out.println("Please specifiy orchestra.properties location with -Dorchestra.properties=<url>.");
                        return;
                    }
                }
                try {
                    Properties orchestraProperties = new Properties();
                    orchestraProperties.load(orchestraPropsStream);
                    jmxServiceUrl = orchestraProperties.getProperty("orchestra.jmx.serviceUrl");
                    jmxObjectName = orchestraProperties.getProperty("orchestra.jmx.objectName");
                }
                catch (Exception e) {
                    throw new OrchestraRuntimeException("Exception occured while loading orchestra.properties", e);
                }
                finally {
                    Misc.close(orchestraPropsStream);
                }
                ArrayList<ClientAction> actions2 = new ArrayList<ClientAction>();
                actions2.add(new DeployAction());
                actions2.add(new DeployBarAction());
                actions2.add(new UndeployAction());
                actions2.add(new StatusAction());
                actions2.add(new ListProcessAction());
                actions2.add(new ListInstanceAction());
                actions2.add(new GetProcessAction());
                actions2.add(new LaunchAction());
                actions2.add(new InitAction());
                if (System.getProperty("extraActionsClasses") != null) {
                    String extraActions = System.getProperty("extraActionsClasses");
                    for (String className : extraActions.split(",")) {
                        try {
                            Class<?> clazz = JMXClient.class.getClassLoader().loadClass(className);
                            Object o = clazz.newInstance();
                            actions2.add((ClientAction)o);
                        }
                        catch (Exception e) {
                            throw new OrchestraRuntimeException("Error while creating action : " + className, e);
                        }
                    }
                }
                boolean done = false;
                for (ClientAction action : actions2) {
                    if (!action.parseAndExecute(args)) continue;
                    done = true;
                }
                if (done) break block23;
                GnuParser parser = new GnuParser();
                try {
                    parser.parse(ClientOptions.createHelpOptions(), args);
                }
                catch (ParseException exp) {
                    StringBuffer strBuf = new StringBuffer();
                    strBuf.append("Error: invalid syntax '");
                    for (String arg : args) {
                        strBuf.append(" " + arg);
                    }
                    strBuf.append("'");
                    throw new OrchestraRuntimeException(strBuf.toString());
                }
                System.out.println("JmxClient for Nova Orchestra");
                System.out.println("List of possible actions:");
                for (ClientAction action : actions2) {
                    JMXClient.printHelp(action.getDescription(), action.getOptions());
                }
            }
            catch (OrchestraRuntimeException e) {
                Throwable cause = e.getCause();
                if (cause instanceof IOException && cause.getCause() instanceof ServiceUnavailableException) {
                    System.out.println("Error during connection to " + jmxServiceUrl + ". Please check that Orchestra is started.");
                }
                System.out.println("Operation failed : " + e.getMessage());
                throw e;
            }
        }
    }
}

