/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.test.remote.replyFault;

import javax.xml.namespace.QName;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPMessage;
import junit.framework.Assert;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.test.remote.RemoteTestCase;
import org.ow2.orchestra.util.SOAPUtil;
import org.ow2.orchestra.util.XmlUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class ReplyFaultTest
extends RemoteTestCase {
    final String processName = "replyFault";
    final String processNamespace = "http://example.com/replyFault";

    public void testAxisReplyFault() {
        try {
            QName processQName = new QName(this.processNamespace, this.processName);
            this.deploy(this.processName);
            String part = "<submit><st>Dupont</st></submit>";
            SOAPMessage request = SOAPUtil.buildDocumentSOAPMessage((String)"http://orchestra.ow2.org/replyFault/submit", (String)"<submit><st>Dupont</st></submit>");
            String endpoint = this.getDefaultEndpoint("replyFaultPort");
            SOAPMessage response = SOAPUtil.call((SOAPMessage)request, (String)endpoint);
            if (response != null) {
                SOAPBodyElement result = (SOAPBodyElement)response.getSOAPBody().getChildElements().next();
                this.checkReturn(result, "Dupont");
            } else {
                Assert.fail((String)"No return available");
            }
            this.undeploy(processQName);
        }
        catch (Exception e) {
            throw new OrchestraRuntimeException((Throwable)e);
        }
    }

    private void checkReturn(SOAPBodyElement result, String name) throws SOAPException {
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((String)"result is not a SOAP Fault", (boolean)(result instanceof SOAPFault));
        SOAPFault fault = (SOAPFault)result;
        Assert.assertEquals((String)this.processNamespace, (String)fault.getFaultCodeAsName().getURI());
        Assert.assertEquals((String)"myFault", (String)fault.getFaultCodeAsName().getLocalName());
        if (fault.getDetail() == null) {
            fault.addDetail();
        }
        Assert.assertNotNull((Object)fault.getDetail());
        Assert.assertNotNull((Object)fault.getDetail().getFirstChild());
        Assert.assertTrue((boolean)(fault.getDetail().getFirstChild() instanceof Element));
        Element submit = (Element)fault.getDetail().getFirstChild();
        Assert.assertEquals((String)"submit", (String)submit.getLocalName());
        Assert.assertNotNull((Object)submit.getFirstChild());
        Assert.assertNotNull((Object)XmlUtil.element((Element)submit));
        Element st = XmlUtil.element((Element)submit);
        Assert.assertEquals((String)"st", (String)st.getLocalName());
        Assert.assertNotNull((Object)st.getFirstChild());
        Assert.assertTrue((boolean)(st.getFirstChild() instanceof Text));
        Text text = (Text)st.getFirstChild();
        Assert.assertEquals((String)name, (String)text.getData());
    }
}

