/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.HashMap;
import org.h2.constant.SysProperties;
import org.h2.message.DbException;
import org.h2.store.DataHandler;
import org.h2.util.IOUtils;
import org.h2.util.New;
import org.h2.util.StringUtils;
import org.h2.util.Utils;
import org.h2.value.Value;
import org.h2.value.ValueLob;
import org.h2.value.ValueLob2;

public class LobStorage {
    public static final int TABLE_ID_SESSION_VARIABLE = -1;
    private static final String LOBS = "INFORMATION_SCHEMA.LOBS";
    private static final String LOB_MAP = "INFORMATION_SCHEMA.LOB_MAP";
    private static final String LOB_DATA = "INFORMATION_SCHEMA.LOB_DATA";
    private static final int BLOCK_LENGTH = 20000;
    private static final boolean HASH = true;
    private static final long UNIQUE = 65535L;
    private Connection conn;
    private HashMap<String, PreparedStatement> prepared = New.hashMap();
    private long nextLob;
    private long nextBlock;
    private final DataHandler handler;
    private boolean init;

    public LobStorage(DataHandler dataHandler) {
        this.handler = dataHandler;
    }

    public void init() {
        if (this.init) {
            return;
        }
        this.conn = this.handler.getLobConnection();
        this.init = true;
        if (this.conn == null) {
            return;
        }
        try {
            Statement statement = this.conn.createStatement();
            statement.execute("CREATE TABLE IF NOT EXISTS INFORMATION_SCHEMA.LOBS(ID BIGINT PRIMARY KEY, LENGTH BIGINT, TABLE INT) HIDDEN");
            statement.execute("CREATE TABLE IF NOT EXISTS INFORMATION_SCHEMA.LOB_MAP(LOB BIGINT, SEQ INT, BLOCK BIGINT, PRIMARY KEY(LOB, SEQ)) HIDDEN");
            statement.execute("CREATE INDEX IF NOT EXISTS INFORMATION_SCHEMA.INDEX_LOB_MAP_DATA_LOB ON INFORMATION_SCHEMA.LOB_MAP(BLOCK, LOB)");
            statement.execute("CREATE TABLE IF NOT EXISTS INFORMATION_SCHEMA.LOB_DATA(BLOCK BIGINT PRIMARY KEY, DATA BINARY) HIDDEN");
            ResultSet resultSet = statement.executeQuery("SELECT MAX(BLOCK) FROM INFORMATION_SCHEMA.LOB_DATA");
            resultSet.next();
            this.nextBlock = resultSet.getLong(1) + 1L;
            this.nextBlock = Math.max(65536L, this.nextLob);
            resultSet = statement.executeQuery("SELECT MAX(ID) FROM INFORMATION_SCHEMA.LOBS");
            resultSet.next();
            this.nextLob = resultSet.getLong(1) + 1L;
        }
        catch (SQLException sQLException) {
            throw DbException.convert(sQLException);
        }
    }

    public void removeAllForTable(int n) {
        if (SysProperties.LOB_IN_DATABASE) {
            this.init();
            try {
                PreparedStatement preparedStatement = this.prepare("SELECT ID FROM INFORMATION_SCHEMA.LOBS WHERE TABLE=?");
                preparedStatement.setInt(1, n);
                ResultSet resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    this.deleteLob(resultSet.getLong(1));
                }
            }
            catch (SQLException sQLException) {
                throw DbException.convert(sQLException);
            }
        }
        ValueLob.removeAllForTable(this.handler, n);
    }

    public static Value createSmallLob(int n, byte[] byArray) {
        if (SysProperties.LOB_IN_DATABASE) {
            return ValueLob2.createSmallLob(n, byArray);
        }
        return ValueLob.createSmallLob(n, byArray);
    }

    private synchronized PreparedStatement prepare(String string) throws SQLException {
        PreparedStatement preparedStatement = this.prepared.get(string);
        if (preparedStatement == null) {
            preparedStatement = this.conn.prepareStatement(string);
            this.prepared.put(string, preparedStatement);
        }
        return preparedStatement;
    }

    private void deleteLob(long l) throws SQLException {
        PreparedStatement preparedStatement = this.prepare("DELETE FROM INFORMATION_SCHEMA.LOB_MAP WHERE LOB = ?");
        preparedStatement.setLong(1, l);
        preparedStatement.execute();
        preparedStatement = this.prepare("DELETE FROM INFORMATION_SCHEMA.LOB_DATA D WHERE BLOCK IN(SELECT M.BLOCK FROM INFORMATION_SCHEMA.LOB_MAP M WHERE LOB = ?) AND NOT EXISTS(SELECT 1 FROM INFORMATION_SCHEMA.LOB_MAP M WHERE M.BLOCK = D.BLOCK AND M.LOB <> ?)");
        preparedStatement.setLong(1, l);
        preparedStatement.setLong(2, l);
        preparedStatement.execute();
        preparedStatement = this.prepare("DELETE FROM INFORMATION_SCHEMA.LOBS WHERE ID = ?");
        preparedStatement.setLong(1, l);
        preparedStatement.execute();
    }

    public InputStream getInputStream(long l) throws IOException {
        this.init();
        return new LobInputStream(this.conn, l);
    }

    private ValueLob2 addLob(InputStream inputStream, long l, int n) {
        byte[] byArray = new byte[20000];
        if (l < 0L) {
            l = Long.MAX_VALUE;
        }
        long l2 = 0L;
        long l3 = this.nextLob++;
        try {
            try {
                int n2 = 0;
                while (l > 0L) {
                    PreparedStatement preparedStatement;
                    byte[] byArray2;
                    int n3 = (int)Math.min(20000L, l);
                    if ((n3 = IOUtils.readFully(inputStream, byArray, 0, n3)) <= 0) break;
                    l2 += (long)n3;
                    l -= (long)n3;
                    if (n3 != byArray.length) {
                        byArray2 = new byte[n3];
                        System.arraycopy(byArray, 0, byArray2, 0, n3);
                    } else {
                        byArray2 = byArray;
                    }
                    boolean bl = false;
                    long l4 = (long)Arrays.hashCode(byArray2) & 0xFFFFL;
                    PreparedStatement preparedStatement2 = this.prepare("SELECT DATA FROM INFORMATION_SCHEMA.LOB_DATA WHERE BLOCK = ?");
                    preparedStatement2.setLong(1, l4);
                    ResultSet resultSet = preparedStatement2.executeQuery();
                    if (resultSet.next()) {
                        byte[] byArray3 = resultSet.getBytes(1);
                        if (Arrays.equals(byArray2, byArray3)) {
                            bl = true;
                        } else {
                            l4 = this.nextBlock++;
                        }
                    }
                    if (!bl) {
                        preparedStatement = this.prepare("INSERT INTO INFORMATION_SCHEMA.LOB_DATA(BLOCK, DATA) VALUES(?, ?)");
                        preparedStatement.setLong(1, l4);
                        preparedStatement.setBytes(2, byArray2);
                        preparedStatement.execute();
                    }
                    preparedStatement = this.prepare("INSERT INTO INFORMATION_SCHEMA.LOB_MAP(LOB, SEQ, BLOCK) VALUES(?, ?, ?)");
                    preparedStatement.setLong(1, l3);
                    preparedStatement.setInt(2, n2);
                    preparedStatement.setLong(3, l4);
                    preparedStatement.execute();
                    ++n2;
                }
                PreparedStatement preparedStatement = this.prepare("INSERT INTO INFORMATION_SCHEMA.LOBS(ID, LENGTH, TABLE) VALUES(?, ?, ?)");
                preparedStatement.setLong(1, l3);
                preparedStatement.setLong(2, l2);
                preparedStatement.setInt(3, -1);
                preparedStatement.execute();
                ValueLob2 valueLob2 = ValueLob2.create(n, this, null, l3, l2);
                return valueLob2;
            }
            catch (IOException iOException) {
                this.deleteLob(l3);
                throw DbException.convertIOException(iOException, "adding blob");
            }
        }
        catch (SQLException sQLException) {
            throw DbException.convert(sQLException);
        }
    }

    public Value createBlob(InputStream inputStream, long l) {
        if (SysProperties.LOB_IN_DATABASE) {
            this.init();
            if (this.conn == null) {
                return ValueLob2.createTempBlob(inputStream, l, this.handler);
            }
            return this.addLob(inputStream, l, 15);
        }
        return ValueLob.createBlob(inputStream, l, this.handler);
    }

    public Value createClob(Reader reader, long l) {
        if (SysProperties.LOB_IN_DATABASE) {
            this.init();
            if (this.conn == null) {
                return ValueLob2.createTempClob(reader, l, this.handler);
            }
            long l2 = l == -1L ? Long.MAX_VALUE : l;
            CountingReaderInputStream countingReaderInputStream = new CountingReaderInputStream(reader, l2);
            ValueLob2 valueLob2 = this.addLob(countingReaderInputStream, Long.MAX_VALUE, 16);
            valueLob2.setPrecision(countingReaderInputStream.getLength());
            return valueLob2;
        }
        return ValueLob.createClob(reader, l, this.handler);
    }

    public void setTable(long l, int n) {
        try {
            PreparedStatement preparedStatement = this.prepare("UPDATE INFORMATION_SCHEMA.LOBS SET TABLE = ? WHERE ID = ?");
            preparedStatement.setInt(1, n);
            preparedStatement.setLong(2, l);
            int n2 = preparedStatement.executeUpdate();
            if (n2 != 1) {
                throw DbException.throwInternalError("count: " + n2);
            }
        }
        catch (SQLException sQLException) {
            throw DbException.convert(sQLException);
        }
    }

    static class CountingReaderInputStream
    extends InputStream {
        private final Reader reader;
        private long length;
        private long remaining;
        private int pos;
        private char[] charBuffer = new char[4096];
        private byte[] buffer;

        CountingReaderInputStream(Reader reader, long l) {
            this.reader = reader;
            this.remaining = l;
            this.buffer = Utils.EMPTY_BYTES;
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            if (this.buffer == null) {
                return -1;
            }
            if (this.pos >= this.buffer.length) {
                this.fillBuffer();
                if (this.buffer == null) {
                    return -1;
                }
            }
            n2 = Math.min(n2, this.buffer.length - this.pos);
            System.arraycopy(this.buffer, this.pos, byArray, n, n2);
            this.pos += n2;
            return n2;
        }

        public int read() throws IOException {
            if (this.buffer == null) {
                return -1;
            }
            if (this.pos >= this.buffer.length) {
                this.fillBuffer();
                if (this.buffer == null) {
                    return -1;
                }
            }
            return this.buffer[this.pos++];
        }

        private void fillBuffer() throws IOException {
            int n = (int)Math.min((long)this.charBuffer.length, this.remaining);
            n = n > 0 ? this.reader.read(this.charBuffer, 0, n) : -1;
            if (n < 0) {
                this.buffer = null;
            } else {
                this.buffer = StringUtils.utf8Encode(new String(this.charBuffer, 0, n));
                this.length += (long)n;
                this.remaining -= (long)n;
            }
            this.pos = 0;
        }

        public long getLength() {
            return this.length;
        }

        public void close() throws IOException {
            this.reader.close();
        }
    }

    public static class LobInputStream
    extends InputStream {
        private final Connection conn;
        private PreparedStatement prepSelect;
        private byte[] buffer;
        private int pos;
        private long remaining;
        private long lob;
        private int seq;

        public LobInputStream(Connection connection, long l) throws IOException {
            this.conn = connection;
            try {
                this.lob = l;
                PreparedStatement preparedStatement = connection.prepareStatement("SELECT LENGTH FROM INFORMATION_SCHEMA.LOBS WHERE ID = ?");
                preparedStatement.setLong(1, l);
                ResultSet resultSet = preparedStatement.executeQuery();
                if (!resultSet.next()) {
                    throw DbException.get(90028, "lob: " + l + " seq: " + this.seq).getSQLException();
                }
                this.remaining = resultSet.getLong(1);
                resultSet.close();
            }
            catch (SQLException sQLException) {
                throw DbException.convertToIOException(sQLException);
            }
        }

        public int read() throws IOException {
            this.fillBuffer();
            if (this.remaining <= 0L) {
                return -1;
            }
            --this.remaining;
            return this.buffer[this.pos++] & 0xFF;
        }

        public int read(byte[] byArray) throws IOException {
            return this.readFully(byArray, 0, byArray.length);
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            return this.readFully(byArray, n, n2);
        }

        private int readFully(byte[] byArray, int n, int n2) throws IOException {
            if (n2 == 0) {
                return 0;
            }
            int n3 = 0;
            while (n2 > 0) {
                this.fillBuffer();
                if (this.remaining <= 0L) break;
                int n4 = (int)Math.min((long)n2, this.remaining);
                n4 = Math.min(n4, this.buffer.length - this.pos);
                System.arraycopy(this.buffer, this.pos, byArray, n, n4);
                this.pos += n4;
                n3 += n4;
                this.remaining -= (long)n4;
                n += n4;
                n2 -= n4;
            }
            return n3 == 0 ? -1 : n3;
        }

        private void fillBuffer() throws IOException {
            if (this.buffer != null && this.pos < this.buffer.length) {
                return;
            }
            if (this.remaining <= 0L) {
                return;
            }
            try {
                if (this.prepSelect == null) {
                    this.prepSelect = this.conn.prepareStatement("SELECT DATA FROM INFORMATION_SCHEMA.LOB_MAP M INNER JOIN INFORMATION_SCHEMA.LOB_DATA D ON M.BLOCK = D.BLOCK WHERE M.LOB = ? AND M.SEQ = ?");
                }
                this.prepSelect.setLong(1, this.lob);
                this.prepSelect.setInt(2, this.seq);
                ResultSet resultSet = this.prepSelect.executeQuery();
                if (!resultSet.next()) {
                    throw DbException.get(90028, "lob: " + this.lob + " seq: " + this.seq).getSQLException();
                }
                ++this.seq;
                this.buffer = resultSet.getBytes(1);
                this.pos = 0;
            }
            catch (SQLException sQLException) {
                throw DbException.convertToIOException(sQLException);
            }
        }
    }
}

