/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.test.integration.sc;

import java.util.HashMap;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import org.ow2.orchestra.pvm.env.Environment;
import org.ow2.orchestra.pvm.internal.cmd.Command;
import org.ow2.orchestra.pvm.internal.cmd.CommandService;
import org.ow2.orchestra.test.BpelTestCase;
import org.ow2.orchestra.test.WSRepository;
import org.ow2.orchestra.test.integration.sc.ABWS;
import org.ow2.orchestra.test.integration.sc.AnalyzerWS;
import org.ow2.orchestra.util.XmlUtil;
import org.ow2.orchestra.var.MessageVariable;
import org.w3c.dom.Element;

public class SCTest
extends BpelTestCase {
    private static final String SA_NS = "http://petals.ow2.org/SA";
    private static final String SB_NS = "http://petals.ow2.org/SB";
    private static final String ANALYZER_NS = "http://petals.ow2.org/SC";
    private static final String SA_PT_NAME = "SAInterface";
    private static final String SB_PT_NAME = "SBInterface";
    private static final String ANALYZER_PT_NAME = "analyzerDocumentInterface";

    public SCTest() {
        super(ANALYZER_NS, "SC");
    }

    public void testGetAdresse() {
        this.getAdresse("13");
    }

    public void testGetAdresseNull() {
        this.getAdresse("1");
    }

    public void testListeGetAdresse() {
        this.getListeAdresse("route du puit");
    }

    public void getAdresse(String id) {
        this.deploy(((Object)((Object)this)).getClass().getResource("SC.bpel"), ((Object)((Object)this)).getClass().getResource("SC.wsdl"));
        Element idElement = XmlUtil.getDocumentWithOneElement((QName)new QName(this.getProcessNamespace(), "id"));
        idElement.setTextContent(id);
        HashMap<String, Element> parts = new HashMap<String, Element>();
        parts.put("IDAdresse", idElement);
        QName portTypeQName = new QName(this.getProcessNamespace(), "SCBPELInterface");
        String operationName = "getAdresse";
        QName saQN = new QName(SA_NS, SA_PT_NAME);
        QName sbQN = new QName(SB_NS, SB_PT_NAME);
        QName analyzerQN = new QName(ANALYZER_NS, ANALYZER_PT_NAME);
        WSRepository.addWS(saQN, new ABWS(SA_NS));
        WSRepository.addWS(sbQN, new ABWS(SB_NS));
        WSRepository.addWS(analyzerQN, new AnalyzerWS(ANALYZER_NS));
        final BpelTestCase.CallResult result = this.call(parts, portTypeQName, "getAdresse");
        CommandService commandService = (CommandService)this.getEnvironmentFactory().get(CommandService.class);
        commandService.execute((Command)new Command<Object>(){

            public Object execute(Environment environment) {
                MessageVariable reply = result.getMessageCarrier().getMessage();
                Assert.assertNotNull((Object)reply);
                Element addressElement = reply.getPartValue("address");
                Assert.assertEquals((int)addressElement.getChildNodes().getLength(), (int)5);
                SCTest.this.deleteInstance(result);
                return null;
            }
        });
        WSRepository.removeWS(saQN);
        WSRepository.removeWS(sbQN);
        WSRepository.removeWS(analyzerQN);
        this.undeploy();
    }

    public void getListeAdresse(String rue) {
        this.deploy(((Object)((Object)this)).getClass().getResource("SC.bpel"), ((Object)((Object)this)).getClass().getResource("SC.wsdl"));
        Element rueElement = XmlUtil.getDocumentWithOneElement((QName)new QName(this.getProcessNamespace(), "rue"));
        rueElement.setTextContent(rue);
        HashMap<String, Element> parts = new HashMap<String, Element>();
        parts.put("rue", rueElement);
        QName portTypeQName = new QName(this.getProcessNamespace(), "SCBPELInterface");
        String operationName = "getListeAdresses";
        QName saQN = new QName(SA_NS, SA_PT_NAME);
        QName sbQN = new QName(SB_NS, SB_PT_NAME);
        QName analyzerQN = new QName(ANALYZER_NS, ANALYZER_PT_NAME);
        WSRepository.addWS(saQN, new ABWS(SA_NS));
        WSRepository.addWS(sbQN, new ABWS(SB_NS));
        WSRepository.addWS(analyzerQN, new AnalyzerWS(ANALYZER_NS));
        final BpelTestCase.CallResult result = this.call(parts, portTypeQName, "getListeAdresses");
        CommandService commandService = (CommandService)this.getEnvironmentFactory().get(CommandService.class);
        commandService.execute((Command)new Command<Object>(){

            public Object execute(Environment environment) {
                MessageVariable reply = result.getMessageCarrier().getMessage();
                Assert.assertNotNull((Object)reply);
                Element addressElement = reply.getPartValue("getListAdressesResponse");
                Assert.assertEquals((int)XmlUtil.elements((Element)addressElement).size(), (int)4);
                Assert.assertEquals((String)XmlUtil.element((Element)XmlUtil.element((Element)addressElement)).getTextContent(), (String)"13");
                SCTest.this.deleteInstance(result);
                return null;
            }
        });
        WSRepository.removeWS(saQN);
        WSRepository.removeWS(sbQN);
        WSRepository.removeWS(analyzerQN);
        this.undeploy();
    }
}

