/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.test.standardElements.transitionCondition;

import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import org.ow2.orchestra.facade.exception.BpelFaultException;
import org.ow2.orchestra.pvm.env.Environment;
import org.ow2.orchestra.pvm.internal.cmd.Command;
import org.ow2.orchestra.pvm.internal.cmd.CommandService;
import org.ow2.orchestra.test.BpelTestCase;
import org.ow2.orchestra.util.XmlUtil;
import org.w3c.dom.Element;

public class TransitionConditionTest
extends BpelTestCase {
    public TransitionConditionTest() {
        super("http://example.com/transitionCondition", "transitionCondition", BpelTestCase.EnvironmentType.JOURNAL);
    }

    public void testTransitionCondition() {
        this.deploy();
        this.launch();
        this.launchBadRequest("badRequest1.xml");
        this.launchBadRequest("badRequest2.xml");
        this.undeploy();
    }

    public void deploy() {
        this.deploy(((Object)((Object)this)).getClass().getResource(this.getProcessName() + ".bpel"), ((Object)((Object)this)).getClass().getResource(this.getProcessName() + ".wsdl"));
    }

    public long launch() {
        URL request = ((Object)((Object)this)).getClass().getResource("request.xml");
        this.assertExists(request);
        HashMap<String, Element> parts = new HashMap<String, Element>();
        parts.put("p", XmlUtil.getDocumentFromURL((URL)request).getDocumentElement());
        QName portTypeQName = new QName(this.getProcessNamespace(), this.getProcessName() + "PT");
        String operationName = "submit";
        final BpelTestCase.CallResult callResult = this.call(parts, portTypeQName, "submit");
        this.waitForInstanceEnd(callResult.getProcessInstanceUUID());
        long endTime = System.currentTimeMillis();
        CommandService commandService = (CommandService)this.getEnvironmentFactory().get(CommandService.class);
        commandService.execute((Command)new Command<Object>(){

            public Object execute(Environment environment) {
                Assert.assertNotNull(callResult.getEvents());
                Assert.assertEquals((int)2, (int)callResult.getEvents().size());
                Iterator<String> i = callResult.getEvents().iterator();
                Assert.assertEquals((String)"B", (String)i.next());
                Assert.assertEquals((String)"A", (String)i.next());
                TransitionConditionTest.this.deleteInstance(callResult);
                return null;
            }
        });
        return endTime;
    }

    public long launchBadRequest(String resource) {
        URL request = ((Object)((Object)this)).getClass().getResource(resource);
        this.assertExists(request);
        HashMap<String, Element> parts = new HashMap<String, Element>();
        parts.put("p", XmlUtil.getDocumentFromURL((URL)request).getDocumentElement());
        QName portTypeQName = new QName(this.getProcessNamespace(), this.getProcessName() + "PT");
        String operationName = "submit";
        BpelTestCase.CallResult callResult = this.call(parts, portTypeQName, "submit");
        BpelFaultException e = this.waitForExceptionInInstance(callResult.getProcessInstanceUUID(), BpelFaultException.class);
        this.deleteInstances(1);
        Assert.assertEquals((Object)BpelFaultException.BpelFault.joinFailure.getQName(), (Object)e.getFaultName());
        return System.currentTimeMillis();
    }
}

