/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.test.jmx;

import java.util.HashMap;
import java.util.List;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import org.ow2.orchestra.env.DefaultEnvXMLGenerator;
import org.ow2.orchestra.env.Environment;
import org.ow2.orchestra.facade.data.runtime.JobData;
import org.ow2.orchestra.facade.exception.InstanceNotFoundException;
import org.ow2.orchestra.facade.exception.JobNotFoundException;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.jmx.RemoteDeployerImpl;
import org.ow2.orchestra.services.commands.Command;
import org.ow2.orchestra.services.commands.CommandService;
import org.ow2.orchestra.services.job.ExecuteInvokeJob;
import org.ow2.orchestra.test.BpelTestCase;
import org.ow2.orchestra.test.WSRepository;
import org.ow2.orchestra.test.wsutils.StringWS;
import org.ow2.orchestra.util.BpelXmlUtil;
import org.ow2.orchestra.util.Misc;
import org.ow2.orchestra.var.MessageVariable;
import org.w3c.dom.Element;

public class FailedJobsTest
extends BpelTestCase {
    public FailedJobsTest() {
        super("http://orchestra.ow2.org/test/failingJob", "failingJobProcess", BpelTestCase.EnvironmentType.CUSTOM);
    }

    protected DefaultEnvXMLGenerator getCustomEnvGenerator() {
        DefaultEnvXMLGenerator envGenerator = BpelTestCase.getBpelTestEnvGenerator();
        envGenerator.setDeadJobHandlerType(new Class[0]);
        return envGenerator;
    }

    public void testFailingJobProcess() {
        this.deploy(((Object)((Object)this)).getClass().getResource(this.getProcessName() + ".bpel"), ((Object)((Object)this)).getClass().getResource(this.getProcessName() + ".wsdl"));
        Element inputElement = BpelXmlUtil.createDefaultElement();
        inputElement.setTextContent("input");
        HashMap<String, Element> parts = new HashMap<String, Element>();
        parts.put("input", inputElement);
        QName portTypeQName = new QName(this.getProcessNamespace(), this.getProcessName() + "PT");
        String operationName = "failingJobProcess";
        BpelTestCase.CallResult result = this.call(parts, portTypeQName, "failingJobProcess");
        RemoteDeployerImpl remoteDeployer = new RemoteDeployerImpl(this.getEnvironmentFactory());
        long pollInterval = 100L;
        long timeout = 180000L;
        long startTime = System.currentTimeMillis();
        List deadJobs = null;
        while (startTime + 180000L + 100L > System.currentTimeMillis() && (deadJobs == null || deadJobs.isEmpty())) {
            deadJobs = remoteDeployer.findJobsWithException();
        }
        Assert.assertNotNull((String)"No dead job found when timeout occured", deadJobs);
        Assert.assertFalse((String)"No dead job found when timeout occured", (boolean)deadJobs.isEmpty());
        Assert.assertEquals((int)1, (int)deadJobs.size());
        JobData jobData = (JobData)deadJobs.get(0);
        Assert.assertEquals((String)ExecuteInvokeJob.class.getName(), (String)jobData.getJobType());
        Assert.assertNotNull((Object)jobData.getException());
        Assert.assertEquals((int)0, (int)jobData.getRetries());
        this.deleteInstances(1);
        this.undeploy();
    }

    public void testRestartFailingJobProcess() {
        this.deploy(((Object)((Object)this)).getClass().getResource(this.getProcessName() + ".bpel"), ((Object)((Object)this)).getClass().getResource(this.getProcessName() + ".wsdl"));
        Element inputElement = BpelXmlUtil.createDefaultElement();
        inputElement.setTextContent("input");
        HashMap<String, Element> parts = new HashMap<String, Element>();
        parts.put("input", inputElement);
        QName portTypeQName = new QName(this.getProcessNamespace(), this.getProcessName() + "PT");
        String operationName = "failingJobProcess";
        final BpelTestCase.CallResult result = this.call(parts, portTypeQName, "failingJobProcess");
        RemoteDeployerImpl remoteDeployer = new RemoteDeployerImpl(this.getEnvironmentFactory());
        long pollInterval = 100L;
        long timeout = 180000L;
        long startTime = System.currentTimeMillis();
        List deadJobs = null;
        while (startTime + 180000L + 100L > System.currentTimeMillis() && (deadJobs == null || deadJobs.isEmpty())) {
            deadJobs = remoteDeployer.findJobsWithException();
        }
        Assert.assertNotNull((String)"No dead job found when timeout occured", deadJobs);
        Assert.assertEquals((int)1, (int)deadJobs.size());
        JobData jobData = (JobData)deadJobs.get(0);
        Assert.assertEquals((String)ExecuteInvokeJob.class.getName(), (String)jobData.getJobType());
        Assert.assertNotNull((Object)jobData.getException());
        Assert.assertEquals((int)0, (int)jobData.getRetries());
        WSRepository.addWS(StringWS.PORTTYPE_QNAME, new StringWS(""));
        try {
            remoteDeployer.retryJob(jobData, 1);
        }
        catch (JobNotFoundException e) {
            Assert.fail((String)"job was not found");
        }
        MessageVariable reply = result.getMessageCarrier().getMessage();
        Assert.assertNotNull((Object)reply);
        ((CommandService)this.getEnvironmentFactory().get(CommandService.class)).execute((Command)new Command<Object>(){

            public Object execute(Environment environment) {
                FailedJobsTest.this.deleteInstance(result);
                return null;
            }
        });
        WSRepository.removeWS(StringWS.PORTTYPE_QNAME);
        this.undeploy();
    }

    public void testExitFailingJobProcess() throws InstanceNotFoundException {
        this.deploy(((Object)((Object)this)).getClass().getResource(this.getProcessName() + ".bpel"), ((Object)((Object)this)).getClass().getResource(this.getProcessName() + ".wsdl"));
        Element inputElement = BpelXmlUtil.createDefaultElement();
        inputElement.setTextContent("input");
        HashMap<String, Element> parts = new HashMap<String, Element>();
        parts.put("input", inputElement);
        QName portTypeQName = new QName(this.getProcessNamespace(), this.getProcessName() + "PT");
        String operationName = "failingJobProcess";
        final BpelTestCase.CallResult result = this.call(parts, portTypeQName, "failingJobProcess");
        RemoteDeployerImpl remoteDeployer = new RemoteDeployerImpl(this.getEnvironmentFactory());
        long pollInterval = 100L;
        long timeout = 180000L;
        long startTime = System.currentTimeMillis();
        List deadJobs = null;
        while (startTime + 180000L + 100L > System.currentTimeMillis() && (deadJobs == null || deadJobs.isEmpty())) {
            deadJobs = remoteDeployer.findJobsWithException();
        }
        Assert.assertNotNull((String)"No dead job found when timeout occured", deadJobs);
        Assert.assertEquals((int)1, (int)deadJobs.size());
        JobData jobData = (JobData)deadJobs.get(0);
        Assert.assertEquals((String)ExecuteInvokeJob.class.getName(), (String)jobData.getJobType());
        Assert.assertNotNull((Object)jobData.getException());
        Assert.assertEquals((int)0, (int)jobData.getRetries());
        remoteDeployer.exit(jobData.getProcessInstanceUUID());
        try {
            result.getMessageCarrier().getMessage();
            Assert.fail((String)"Process should be exited before the reply activity");
        }
        catch (OrchestraRuntimeException e) {
            Assert.assertEquals((String)"No reply message available. No process was found for the message or the process execution failed.", (String)e.getMessage());
        }
        ((CommandService)this.getEnvironmentFactory().get(CommandService.class)).execute((Command)new Command<Object>(){

            public Object execute(Environment environment) {
                FailedJobsTest.this.deleteInstance(result);
                return null;
            }
        });
        this.undeploy();
    }

    public void testRestartInvalidJob() {
        RemoteDeployerImpl remoteDeployer = new RemoteDeployerImpl(this.getEnvironmentFactory());
        long jobId = Misc.random((int)250, (int)3500);
        JobData jobData = new JobData(null, jobId, false, null, null, 0, null, null);
        try {
            remoteDeployer.retryJob(jobData, 3);
            Assert.fail((String)"Expecting exception");
        }
        catch (JobNotFoundException e) {
            Assert.assertEquals((Object)jobData, (Object)e.getJob());
        }
    }
}

