/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.axis;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.felix.framework.Felix;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StartupListener
implements ServletContextListener {
    private Felix felix;

    public void contextInitialized(ServletContextEvent event) {
        try {
            HashMap<String, String> config = new HashMap<String, String>();
            config.put("org.osgi.framework.system.packages.extra", "javax.servlet;javax.servlet.http;version=2.5, org.postgresql, com.mysql.jdbc, org.h2, org.apache.derby.jdbc, oracle.jdbc, com.sun.org.apache.xerces.internal.dom, com.sun.org.apache.xerces.internal.jaxp, com.sun.org.apache.xalan.internal.xsltc.dom, com.sun.org.apache.xml.internal.dtm, com.sun.org.apache.xalan.internal.xsltc.trax");
            URL url = event.getServletContext().getResource("/WEB-INF/web.xml");
            URL libURL = new URL(url, "lib");
            config.put("felix.auto.deploy.dir", libURL.toExternalForm());
            config.put("felix.auto.deploy.action", "install, update, start");
            config.put("felix.log.level", "1");
            config.put("felix.cache.rootdir", System.getProperty("java.io.tmpdir"));
            config.put("org.osgi.framework.storage.clean", "onFisrtInit");
            config.put("orchestra.war.context", "true");
            this.felix = new Felix(config);
            this.felix.init();
            this.installBundles(this.felix.getBundleContext(), event.getServletContext());
            this.felix.start();
            event.getServletContext().setAttribute(BundleContext.class.getName(), (Object)this.felix.getBundleContext());
            event.getServletContext().log("OSGi framework started", null);
        }
        catch (Exception e) {
            event.getServletContext().log("Error starting framework", (Throwable)e);
        }
    }

    public void contextDestroyed(ServletContextEvent event) {
        try {
            if (this.felix != null) {
                this.felix.stop();
            }
        }
        catch (Exception e) {
            event.getServletContext().log("Error stopping framework", (Throwable)e);
        }
    }

    public void installBundles(BundleContext context, ServletContext servletContext) throws Exception {
        ArrayList<Bundle> installed = new ArrayList<Bundle>();
        for (URL url : this.findBundles(servletContext)) {
            servletContext.log("Installing bundle [" + url + "]");
            Bundle bundle = context.installBundle(url.toExternalForm());
            installed.add(bundle);
        }
        for (Bundle bundle : installed) {
            if (bundle.getHeaders().get("Fragment-Host") != null) continue;
            bundle.start();
        }
    }

    private List<URL> findBundles(ServletContext servletContext) throws Exception {
        ArrayList<URL> list = new ArrayList<URL>();
        for (Object o : servletContext.getResourcePaths("/WEB-INF/lib/")) {
            URL url;
            String name = (String)o;
            if (!name.endsWith(".jar") || -1 != name.lastIndexOf("org.apache.felix.framework") || (url = servletContext.getResource(name)) == null) continue;
            list.add(url);
        }
        return list;
    }
}

