/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.axis.example.weather;

import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPMessage;
import org.ow2.orchestra.axis.AxisConfiguration;
import org.ow2.orchestra.axis.test.AxisTestCase;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.pvm.internal.util.XmlUtil;
import org.ow2.orchestra.util.BpelUtil;
import org.ow2.orchestra.util.SOAPUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class WeatherTest
extends AxisTestCase {
    public void testWeather() {
        try {
            String processName = "weather";
            String processNamespace = "http://orchestra.ow2.org/weather";
            QName processQName = new QName(processNamespace, processName);
            this.deploy(((Object)((Object)this)).getClass().getResource(processName + ".bpel"), ((Object)((Object)this)).getClass().getResource(processName + "Artifacts.wsdl"));
            AxisConfiguration config = AxisConfiguration.getInstance();
            String endpoint = "http://" + config.getHost() + ":" + config.getPort() + "/" + config.getWebappName() + "/" + config.getServletPath() + "/" + "weatherPT";
            SOAPMessage request = SOAPUtil.buildDocumentSOAPMessage((String)"http://orchestra.ow2.org/weatherArtifacts/process", (String)"<weatherRequest xmlns='http://orchestra.ow2.org/weather'><input>Grenoble,France</input></weatherRequest>");
            SOAPMessage response = SOAPUtil.call((SOAPMessage)request, (String)endpoint);
            if (response != null) {
                SOAPBodyElement result = (SOAPBodyElement)response.getSOAPBody().getChildElements().next();
                WeatherTest.assertNotNull((Object)result);
                WeatherTest.assertEquals((String)XmlUtil.toString((Element)result), (String)"weatherResponse", (String)result.getLocalName());
                WeatherTest.assertEquals((String)processNamespace, (String)result.getNamespaceURI());
                List children = BpelUtil.getElements((Node)result);
                WeatherTest.assertEquals((int)1, (int)children.size());
                WeatherTest.assertEquals((String)"result", (String)((Element)children.get(0)).getLocalName());
                WeatherTest.assertEquals((String)processNamespace, (String)((Element)children.get(0)).getNamespaceURI());
                List texts = BpelUtil.getTexts((Node)((Node)children.get(0)));
                WeatherTest.assertEquals((int)1, (int)texts.size());
                String s = ((Text)texts.get(0)).getData();
                Document doc = BpelUtil.getDocumentFromString((String)s);
                WeatherTest.assertNotNull((Object)doc);
                Element rootElement = doc.getDocumentElement();
                WeatherTest.assertNotNull((Object)rootElement);
                WeatherTest.assertEquals((String)"CurrentWeather", (String)rootElement.getTagName());
                List elements = BpelUtil.getElements((Node)rootElement);
                WeatherTest.assertTrue((elements.size() >= 8 ? 1 : 0) != 0);
                Element location = (Element)rootElement.getElementsByTagName("Location").item(0);
                WeatherTest.assertEquals((String)"Grenoble / St. Geoirs, France (LFLS) 45-22N 005-20E 386M", (String)location.getTextContent());
            } else {
                WeatherTest.assertTrue((String)"No return available", (boolean)false);
            }
            this.undeploy(processQName);
        }
        catch (Exception e) {
            throw new OrchestraRuntimeException(e);
        }
    }
}

