/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.axis.test.fail;

import java.net.URL;
import java.util.UUID;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPMessage;
import junit.framework.Assert;
import org.ow2.orchestra.axis.AxisConfiguration;
import org.ow2.orchestra.axis.AxisDeployAction;
import org.ow2.orchestra.axis.test.AxisTestCase;
import org.ow2.orchestra.exception.FaultWithMessage;
import org.ow2.orchestra.util.SOAPUtil;

public class AxisFaultTest
extends AxisTestCase {
    private static final String processName = "failBpel";
    private static final String processNamespace = "http://orchestra.ow2.org/failBpel";
    private static final QName processQName = new QName("http://orchestra.ow2.org/failBpel", "failBpel");
    private static final AxisConfiguration config = AxisConfiguration.getInstance();
    private static final String webappPath = "http://" + config.getHost() + ":" + config.getPort() + "/" + config.getWebappName();
    private static final String adminEndpoint = webappPath + "/servlet/AxisServlet";
    private boolean responded = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAxisFaultTransformation() throws Exception {
        Thread t = null;
        Object testException = null;
        AxisDeployAction.deployWS((String)adminEndpoint, (URL)AxisFaultTest.class.getResource("deploy.wsdd"));
        this.deploy(processName);
        try {
            t = new Thread(new AxisFaultTestThread(this));
            t.setDaemon(true);
            t.start();
            this.waitForExceptionInInstance(processQName, FaultWithMessage.class, null);
            Assert.assertFalse((boolean)this.responded);
        }
        finally {
            if (t != null) {
                t.interrupt();
            }
        }
        this.undeploy(processQName);
        AxisDeployAction.deployWS((String)adminEndpoint, (URL)AxisFaultTest.class.getResource("undeploy.wsdd"));
    }

    private class AxisFaultTestThread
    implements Runnable {
        private final AxisFaultTest axisFaultTest;

        public AxisFaultTestThread(AxisFaultTest axisFaultTest2) {
            this.axisFaultTest = axisFaultTest2;
        }

        public void run() {
            String random = UUID.randomUUID().toString();
            String part = "<failBpelRequest xmlns='http://orchestra.ow2.org/failBpel'>" + random + "</failBpelRequest>";
            String processEndpoint = webappPath + "/" + config.getServletPath() + "/" + "failBpelPort";
            SOAPMessage request = SOAPUtil.buildDocumentSOAPMessage((String)AxisFaultTest.processNamespace, (String)part);
            SOAPUtil.call((SOAPMessage)request, (String)processEndpoint);
            this.axisFaultTest.responded = true;
        }
    }
}

