/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.axis.test.hello2OneBinding;

import javax.xml.namespace.QName;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPMessage;
import junit.framework.Assert;
import junit.framework.AssertionFailedError;
import org.ow2.orchestra.axis.AxisConfiguration;
import org.ow2.orchestra.axis.test.AxisTestCase;
import org.ow2.orchestra.util.SOAPUtil;
import org.w3c.dom.Text;

public class Hello2OneServiceTest
extends AxisTestCase {
    public void testAxisHello2() {
        try {
            String processName = "hello2OneService";
            String processNamespace = "http://orchestra.ow2.org/demos/hello2OneService";
            QName processQName = new QName(processNamespace, processName);
            this.deploy(processName);
            Hello2CallHelloTextPT helloTextCall = new Hello2CallHelloTextPT();
            Hello2CallHelloPT helloCall = new Hello2CallHelloPT();
            Thread t1 = new Thread(helloTextCall);
            Thread t2 = new Thread(helloCall);
            t1.start();
            t2.start();
            while (t1.isAlive() || t2.isAlive()) {
                t1.join(100L);
                t2.join(100L);
                if (helloCall.getTrowable() != null) {
                    throw new AssertionFailedError("Error in thread").initCause(helloCall.getTrowable());
                }
                if (helloTextCall.getTrowable() == null) continue;
                throw new AssertionFailedError("Error in thread").initCause(helloTextCall.getTrowable());
            }
            this.undeploy(processQName);
        }
        catch (Throwable e) {
            if (e instanceof AssertionFailedError) {
                throw (AssertionFailedError)e;
            }
            e.printStackTrace();
            Hello2OneServiceTest.assertTrue((boolean)false);
        }
    }

    static class Hello2CallHelloTextPT
    implements Runnable {
        private Throwable uncaughtException;

        Hello2CallHelloTextPT() {
        }

        public Throwable getTrowable() {
            return this.uncaughtException;
        }

        public void run() {
            try {
                String part = "<setHelloText>coucou </setHelloText>";
                SOAPMessage request = SOAPUtil.buildDocumentSOAPMessage((String)"http://orchestra.ow2.org/hello2OneService/setHelloText", (String)part);
                AxisConfiguration config = AxisConfiguration.getInstance();
                String endpoint = "http://" + config.getHost() + ":" + config.getPort() + "/" + config.getWebappName() + "/" + config.getServletPath() + "/" + "helloTextPT";
                SOAPMessage response = SOAPUtil.call((SOAPMessage)request, (String)endpoint);
                if (response != null) {
                    SOAPBodyElement result = (SOAPBodyElement)response.getSOAPBody().getChildElements().next();
                    Assert.assertNotNull((Object)result);
                    Assert.assertEquals((String)result.toString(), (String)"setHelloText", (String)result.getElementName().getLocalName());
                    Assert.assertNotNull((Object)result.getFirstChild());
                    Assert.assertTrue((boolean)(result.getFirstChild() instanceof Text));
                    Text text = (Text)result.getFirstChild();
                    Assert.assertEquals((String)"coucou", (String)text.getData());
                } else {
                    Assert.assertTrue((String)"No return available", (boolean)false);
                }
            }
            catch (Throwable e) {
                this.uncaughtException = e;
            }
        }
    }

    static class Hello2CallHelloPT
    implements Runnable {
        private Throwable uncaughtException;

        Hello2CallHelloPT() {
        }

        public Throwable getTrowable() {
            return this.uncaughtException;
        }

        public void run() {
            try {
                String part = "<name>toto</name>";
                SOAPMessage request = SOAPUtil.buildDocumentSOAPMessage((String)"http://orchestra.ow2.org/hello2OneService/sayHello", (String)part);
                AxisConfiguration config = AxisConfiguration.getInstance();
                String endpoint = "http://" + config.getHost() + ":" + config.getPort() + "/" + config.getWebappName() + "/" + config.getServletPath() + "/" + "helloPT";
                SOAPMessage response = SOAPUtil.call((SOAPMessage)request, (String)endpoint);
                if (response != null) {
                    SOAPBodyElement result = (SOAPBodyElement)response.getSOAPBody().getChildElements().next();
                    Assert.assertNotNull((Object)result);
                    Assert.assertNotNull((Object)result.getFirstChild());
                    Assert.assertTrue((String)"Fail here because there are two operations in the same binding", (boolean)(result.getFirstChild() instanceof Text));
                    Text text = (Text)result.getFirstChild();
                    Assert.assertEquals((String)"coucou toto", (String)text.getData());
                } else {
                    Assert.assertTrue((String)"No return available", (boolean)false);
                }
            }
            catch (Throwable e) {
                this.uncaughtException = e;
            }
        }
    }
}

