/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.axis.test.perf;

import java.util.HashMap;
import java.util.UUID;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPMessage;
import junit.framework.Assert;
import junit.framework.AssertionFailedError;
import org.ow2.orchestra.axis.test.perf.AxisPerfTestCase;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.pvm.internal.util.XmlUtil;
import org.ow2.orchestra.util.BpelUtil;
import org.ow2.orchestra.util.BpelXmlUtil;
import org.ow2.orchestra.util.SOAPUtil;
import org.ow2.orchestra.var.Message;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class MarketplaceTest
extends AxisPerfTestCase {
    protected String getProcessName() {
        return "marketplace";
    }

    protected String getProcessNamespace() {
        return "http://orchestra.ow2.org/marketplace";
    }

    public void deploy() {
        this.deploy(org.ow2.orchestra.test.perf.marketplace.MarketplaceTest.class.getResource(this.getProcessName() + ".bpel"), org.ow2.orchestra.test.perf.marketplace.MarketplaceTest.class.getResource(this.getProcessName() + ".wsdl"));
    }

    public long launch() {
        String item = "item-" + UUID.randomUUID().toString();
        int buyerPrice = BpelUtil.getRandomInt((long)0L, (int)1000);
        int sellerPrice = BpelUtil.getRandomInt((long)-45L, (int)1000);
        BuyerThread buyerThread = new BuyerThread(item, buyerPrice);
        SellerThread sellerThread = new SellerThread(item, sellerPrice);
        buyerThread.start();
        sellerThread.start();
        try {
            while (!buyerThread.ended || !sellerThread.ended) {
                buyerThread.join(1000L);
                sellerThread.join(1000L);
                if (buyerThread.exception != null) {
                    throw new OrchestraRuntimeException("Exception in buyer thread", buyerThread.exception);
                }
                if (sellerThread.exception == null) continue;
                throw new OrchestraRuntimeException("Exception in seller thread", sellerThread.exception);
            }
        }
        catch (Exception e) {
            throw new OrchestraRuntimeException("Exception while joining buyer and seller threads : " + e.getMessage(), e);
        }
        long endTime = System.currentTimeMillis();
        SOAPMessage buyerResponse = buyerThread.getReply();
        SOAPMessage sellerResponse = sellerThread.getReply();
        String buyerOutcome = this.getOutcome(buyerResponse, "buyer");
        String sellerOutcome = this.getOutcome(sellerResponse, "seller");
        org.ow2.orchestra.test.perf.marketplace.MarketplaceTest.chekOutcomes((int)buyerPrice, (String)buyerOutcome, (int)sellerPrice, (String)sellerOutcome);
        return endTime;
    }

    private String getOutcome(SOAPMessage response, String operationName) {
        SOAPBodyElement result = this.getSOAPBodyElement(response);
        try {
            Assert.assertNotNull((Object)result);
            Assert.assertEquals((String)operationName, (String)result.getElementName().getLocalName());
            Assert.assertNotNull((Object)result.getFirstChild());
            Assert.assertTrue((boolean)(result.getFirstChild() instanceof Element));
            Element st = (Element)result.getFirstChild();
            Assert.assertEquals((String)"outcome", (String)st.getLocalName());
            Assert.assertNotNull((Object)st.getFirstChild());
            Assert.assertTrue((boolean)(st.getFirstChild() instanceof Text));
            Text text = (Text)st.getFirstChild();
            return text.getData();
        }
        catch (Exception e) {
            throw new OrchestraRuntimeException("Exception while getting outcome", e);
        }
        catch (AssertionFailedError e) {
            System.err.println("result = " + BpelUtil.getNodeAsString((Node)result));
            throw e;
        }
    }

    public void testMarketplace() {
        this.deploy();
        this.launch();
        this.undeploy();
    }

    public String getAlias() {
        return "axis.market";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class SellerThread
    extends MPThread {
        public SellerThread(String item, int price) {
            super(item, price);
        }

        @Override
        public HashMap<String, Document> getParts() {
            HashMap<String, Document> parts = new HashMap<String, Document>();
            parts.put("inventoryItem", BpelXmlUtil.createElementWithContent((String)this.item).getOwnerDocument());
            parts.put("askingPrice", BpelXmlUtil.createElementWithContent((String)Integer.toString(this.price)).getOwnerDocument());
            return parts;
        }

        @Override
        public String getOperationName() {
            return "seller";
        }

        @Override
        public String getPort() {
            return "sellerPort";
        }

        @Override
        public String getSOAPAction() {
            return "http://orchestra.ow2.org/marketplace/seller";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class BuyerThread
    extends MPThread {
        public BuyerThread(String item, int price) {
            super(item, price);
        }

        @Override
        public HashMap<String, Document> getParts() {
            HashMap<String, Document> parts = new HashMap<String, Document>();
            parts.put("item", BpelXmlUtil.createElementWithContent((String)this.item).getOwnerDocument());
            parts.put("offer", BpelXmlUtil.createElementWithContent((String)Integer.toString(this.price)).getOwnerDocument());
            return parts;
        }

        @Override
        public String getOperationName() {
            return "buyer";
        }

        @Override
        public String getPort() {
            return "buyerPort";
        }

        @Override
        public String getSOAPAction() {
            return "http://orchestra.ow2.org/marketplace/buyer";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public abstract class MPThread
    extends Thread {
        protected String item;
        protected int price;
        protected SOAPMessage response;
        protected Throwable exception = null;
        protected boolean ended = false;

        public MPThread(String item, int price) {
            this.item = item;
            this.price = price;
        }

        public SOAPMessage getReply() {
            return this.response;
        }

        public abstract HashMap<String, Document> getParts();

        public abstract String getOperationName();

        public abstract String getSOAPAction();

        public abstract String getPort();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Message message = new Message(this.getParts());
                SOAPMessage request = SOAPUtil.buildRpcSOAPMessage((String)this.getSOAPAction(), (Message)message, (String)this.getOperationName());
                String endpoint = MarketplaceTest.this.getDefaultEndpoint(this.getPort());
                this.response = SOAPUtil.call((SOAPMessage)request, (String)endpoint);
                if (this.response != null) {
                    SOAPBodyElement result = (SOAPBodyElement)this.response.getSOAPBody().getChildElements().next();
                    Assert.assertNotNull((Object)result);
                    Assert.assertFalse((String)XmlUtil.toString((Element)result), (boolean)"Fault".equals(result.getElementName().getLocalName()));
                } else {
                    Assert.assertTrue((String)"No return available", (boolean)false);
                }
            }
            catch (Throwable e) {
                this.exception = e;
                e.printStackTrace();
            }
            finally {
                this.ended = true;
            }
        }
    }
}

